local AceLocale = LibStub:GetLibrary("AceLocale-3.0")
local L = AceLocale:NewLocale("Raven", "enUS", true)
if not L then return end

-- Main.lua
L["Raven"] = true
L["Raven left click"] = "|cffffff00Left-click|r to open/close options menu"
L["Raven right click"] = "|cffffff00Right-click|r to toggle locking all bar groups"
L["Raven shift left click"] = "|cffffff00Shift-left-click|r to enable/disable Raven"
L["Raven shift right click"] = "|cffffff00Shift-right-click|r to toggle Blizzard buffs"
L["Shared Potion Cooldown"] = true
L["Shared Elixir Cooldown"] = true
L["Global Cooldown"] = true
L["GCD"] = true -- abbreviation for Global Cooldown
L["Failed to load "] = true
L["Not Tracking"] = true
L["Potions"] = true
L["Elixirs"] = true

-- Profile.lua
L["Frost School"] = true
L["Fire School"] = true
L["Nature School"] = true
L["Shadow School"] = true
L["Arcane School"] = true
L["Holy School"] = true
L["Physical School"] = true
L["Locked out of Frost school of magic."] = true
L["Locked out of Fire school of magic."] = true
L["Locked out of Nature school of magic."] = true
L["Locked out of Shadow school of magic."] = true
L["Locked out of Arcane school of magic."] = true
L["Locked out of Holy school of magic."] = true
L["Locked out of Physical school of magic."] = true

-- Bars.lua
L["Test Bar"] = true
L["Timer Bar"] = true
L["Custom Bar Group"] = true
L["Auto Bar Group"] = true
L["Anchor attached"] = '|cffffff00Attached|r to "'
L["Anchor left click 1"] = "|cffffff00Left-click|r to unattach and then move the anchor"
L["Anchor left click 2"] = "|cffffff00Left-click|r to move the anchor"
L["Anchor right click"] = "|cffffff00Right-click|r to lock and hide the anchor"
L["Anchor shift left click"] = "|cffffff00Shift-left-click|r to toggle test bars"
L["Anchor shift right click"] = "|cffffff00Shift-right-click|r to toggle direction"
L["Anchor alt left click"] = "|cffffff00Alt-left-click|r to open/close options menu"
L["Anchor alt right click"] = "|cffffff00Alt-right-click|r to cycle through configurations"
L["Add filter"] = function(a, b, n) return string.format("Raven: \"%s\" added to %s filter list for bar group \"%s\"", a, b, n) end
L["Header click"] = "|cffffff00Right-click|r to hide unit until re-targeted or next spell tick or spell is reapplied"
L["Header shift click"] = "|cffffff00Shift-right-click|r to hide all units with same name"
L["<Applied by "] = true

-- Conditions.lua
-- These strings are used in GetConditionText function to produce a detail condition description.
-- Many are also used in the options panel in the Conditions tab for defining tests.
L["Player Status"] = PLAYER_STATUS
L["Target Status"] = true
L["Target's Target Status"] = true
L["Focus Status"] = true
L["Focus's Target Status"] = true
L["All Buffs"] = true
L["Any Buffs"] = true
L["Buff Time Left"] = true
L["Buff Count"] = true
L["Buff Type"] = true
L["All Debuffs"] = true
L["Any Debuffs"] = true
L["Debuff Time Left"] = true
L["Debuff Count"] = true
L["Debuff Type"] = true
L["All Cooldowns"] = true
L["Spell Ready"] = true
L["Spell Casting"] = true
L["Item Ready"] = true
L["Condition Name"] = function(name) return string.format("|cFF7adbf2Condition Name:|r %s", name) end
L["(not found)"] = true
L["Disable String"] = " |cFFef2929[DISABLED]|r"
L["In Combat"] = GARRISON_LANDING_STATUS_MISSION_COMBAT
L["Out Of Combat"] = true
L["Is Resting"] = true
L["Not Resting"] = true
L["Is Stealthed"] = true
L["Not Stealthed"] = true
L["Is Mounted"] = true
L["Not Mounted"] = true
L["Is PvP"] = true
L["Not PvP"] = true
L["In Group"] = true
L["Not In Group"] = true
L["In Party"] = true
L["Not In Party"] = true
L["In Raid"] = true
L["Not In Raid"] = true
L["In Instance"] = true
L["Not In Instance"] = true
L["In Arena"] = true
L["Not In Arena"] = true
L["In Battleground"] = true
L["Not In Battleground"] = true
L["On Taxi"] = true
L["In Pet Battle"] = true
L["Enter comma-separated specialization names or numbers to check (leave blank to ignore specialization)."] = true
L["Has Pet"] = true
L["No Pet"] = true
L["Level String"] = function(x, level) return string.format("Level %s %d", x, level) end
L["Health String"] = function(x, minHealth) return string.format("Health %s %d%%", x, minHealth) end
L["Power String"] = function(x, minPower) return string.format("Power %s %d", x, minPower) end
L["Holy Power String"] = function(x, minPower) return string.format("Holy Power %s %d", x, minPower) end
L["Shards String"] = function(x, minShards) return string.format("Shards %s %d", x, minShards) end
L["Arcane Charges String"] = function(x, minPower) return string.format("Arcane Charges %s %d", x, minPower) end
L["Insanity String"] = function(x, minPower) return string.format("Insanity %s %d", x, minPower) end
L["Maelstrom String"] = function(x, minPower) return string.format("Maelstrom %s %d", x, minPower) end
L["Chi String"] = function(x, minPower) return string.format("Chi %s %d", x, minPower) end
L["Lunar String"] = function(x, power) return string.format("Lunar Power %s %d", x, power) end
L["Combo Pts String"] = function(x, minComboPoints) return string.format("Combo Pts %s %d", x, minComboPoints) end
L["Runes String"] = function(x, minRunes) return string.format("Runes %s %d", x, minRunes) end
L["Stance String"] = function(stance) return string.format("Stance = \"%s\"", stance) end
L["Totem String"] = function(totem) return string.format("Totem = \"%s\"", totem) end
L["Talent String"] = function(talent) return string.format("Talent = \"%s\"", talent) end
L["Spec String"] = function(spec) return string.format("Specialization = \"%s\"", spec) end
L["Spell String"] = function(spell) return string.format("Spell = \"%s\"", spell) end
L["Max Health String"] = function(maxh) return string.format("Max Health >= \"%d\"", tonumber(maxh) or 0) end
L["Pet Family String"] = function(family) return string.format("Family = \"%s\"", family) end
L["Pet Spec String"] = function(spec) return string.format("Talent Tree = \"%s\"", spec) end
L["Rune"] = true
L["Runes"] = true
L["Mainhand String"] = function(level) return string.format("Weapon Mainhand >= %d", level) end
L["Offhand String"] = function(level) return string.format("Weapon Offhand >= %d", level) end
L["Exists"] = true
L["Not Exists"] = true
L["Is Player"] = true
L["Not Player"] = true
L["Is Enemy"] = true
L["Not Enemy"] = true
L["Is Friendly"] = true
L["Not Friendly"] = true
L["Is Dead"] = true
L["Not Dead"] = true
L["In Range"] = true
L["Out Of Range"] = true
L["Is "] = true
L["Not "] = true
L["On"] = true
L["Not All Active"] = true
L["All Active"] = true
L["None Active"] = true
L["Any Active"] = true
L["Cast By Player"] = true
L["Cast By Other"] = true
L["Cast By Anyone"] = true
L["Missing"] = true
L["Present"] = true
L["Less Than"] = true
L["Or More"] = true
L["Seconds"] = true
L["Seconds Or More"] = true
L["Test Global Cooldown"] = true
L["Ignore Global Cooldown"] = true
L["Ignore Spell Usable"] = true
L["Test Spell Usable"] = true
L["Target In Range"] = true
L["Target Out Of Range"] = true
L["Cast By"] = true							
L["Item Is Not Ready"] = true
L["Item Is Ready"] = true
L["Dependencies String"] = "\n|cFF7adbf2Dependencies:|r"
L["True Color String"] = "|cFF8ae234True|r"
L["False Color String"] = "|cFFef2929False|r"
L["Logic AND String"] = "\n|cFF7adbf2Evaluate Tests With Logical And, "
L["Logic OR String"] = "\n|cFF7adbf2Evaluate Tests With Logical Or, "
L["Toggle String"] = "Toggle Result|r"
L["No Toggle String"] = "Do Not Toggle Result|r"
L["Set Result True"] = "\n|cFF7adbf2Set Result True|r"
L["Set Result False"] = "\n|cFF7adbf2Set Result False|r"
L["Current Value String"] = "\n|cFF7adbf2Current Value: |r"
L["Normal"] = true
L["Boss"] = BOSS
L["Elite"] = ELITE
L["Rare"] = true
L["Rare Elite"] = true
L["Dead"] = true
L["Ghost"] = true

-- Nest.lua
L["Right-to-left bars, label left, icon left"] = true
L["Left-to-right bars, label left, icon left"] = true
L["Right-to-left bars, label right, icon left"] = true
L["Left-to-right bars, label right, icon left"] = true
L["Right-to-left bars, label left, icon right"] = true
L["Left-to-right bars, label left, icon right"] = true
L["Right-to-left bars, label right, icon right"] = true
L["Left-to-right bars, label right, icon right"] = true
L["Icons in rows, with right-to-left mini-bars"] = true
L["Icons in rows, with left-to-right mini-bars"] = true
L["Icons in columns, right-to-left mini-bars"] = true
L["Icons in columns, left-to-right mini-bars"] = true
L["Icons on horizontal timeline, no mini-bars"] = true
L["Icons on vertical timeline, no mini-bars"] = true
L["Icons with variable width on horizontal stripe"] = true

-- L["Buff button right click"] = "|cffffff00Right-click|r to cancel this buff"

-- Shared cooldowns
L["Summon Infernal/Doomguard"] = true

-- All strings from here down are used for the options panel and are referenced in Options.lua.

L["Not valid string"] = function(n) return string.format("Raven: warning \"%s\" is not a recognized spell name (disable warnings to use it anyway)", n) end
L["Circular string"] = function(a, b) return string.format("Raven: \"%s\" cannot be attached to \"%s\" because that creates a circular dependency", a, b) end
L["Dup bar group string"] = function(n) return string.format("DUPLICATE NAME\nThere is already a bar group named %s. Do you want to overwrite it?", n) end
L["Dup condition string"] = function(n) return string.format("DUPLICATE NAME\nThere is already a condition named %s. Do you want to overwrite it?", n) end
L["is a duplicate of an existing bar label"] = true
L["does not begin with a letter or contains restricted characters"] = true
L["Unconditional string"] = function(t) return string.format("|cFF7adbf2Type:|r %s\n|cFF7adbf2Unconditional|r", t) end
L["Type and condition string"] = function(t, a) return string.format("|cFF7adbf2Type:|r %s\n|cFF7adbf2Condition:|r %s", t, a) end
L["Associated spell string"] = function(s) return string.format("\n|cFF7adbf2Associated Spell:|r %s", s) end
L["Broker string"] = function(t, a) return string.format("|cFF7adbf2Type:|r %s\n|cFF7adbf2Name:|r %s", t, a) end
L["Broker data source string"] = "\n|cFF7adbf2Class:|r Data Source"
L["Broker launcher string"] = "\n|cFF7adbf2Class:|r Launcher"
L["Value string"] = function(t, a) return string.format("|cFF7adbf2Type:|r %s\n|cFF7adbf2Name:|r %s", t, a) end
L["Color string"] = "\n|cFF7adbf2Color:|r "
L["Unit string"] = "\n|cFF7adbf2Unit:|r "
L["Type action string"] = function(a, t, s) return string.format("|cFF7adbf2Type:|r %s\n|cFF7adbf2Action:|r %s", t, a) end
L["Type string"] = function(t, s) return string.format("|cFF7adbf2Type:|r %s", t) end
L["Action on cast by string"] = function(m, c) return string.format("\n|cFF7adbf2Action On:|r %s\n|cFF7adbf2Cast By:|r %s", m, c) end
L["Comment string"] = "\n|cFF7adbf2Comment:|r "

-- Blizzard Addons option table
L["Configure"] = true
L["Open Raven's standalone options panel."] = true

-- Setup tab
L["Setup"] = true
L["Enable Raven"] = true
L["If checked, Raven is enabled, otherwise all features are disabled."] = true
L["Hide Blizzard"] = true
L["If checked, Raven will hide selected parts of the default user interface, otherwise it will try to show them (select parts on the Defaults tab)."] = true
L["Mute Raven Sound"] = true
L["If checked, Raven will not play sound effects."] = true
L["Minimap Icon"] = true
L["If checked, Raven will add an icon to the minimap."] = true
L["Standard Bar Groups"] = true
L["Anchor description"] = "Raven lets you display bars and icons for buffs, debuffs and cooldowns. " ..
	'You can use the many options under the "Bar Groups" tab to set up a personalized user interface. ' ..
	"To get started, however, it may be easier to begin with the standard bar groups listed here. " ..
	'Select the ones you want and then click either "Create As Bars" or "Create As Icons". ' ..
	'You can do this multiple times to configure a mix of bars and icons.\n'
L["All buffs on the player."] = true
L["Short Buffs"] = true
L["Buffs on the player lasting less than 2 minutes."] = true
L["Long Buffs"] = true
L["Buffs on the player lasting at least 2 minutes."] = true
L["Debuffs"] = true
L["Debuffs on the player."] = true
L["Cooldowns"] = true
L["Cooldowns for the player lasting at least 2 seconds."] = true
L["Target"] = TARGET
L["Buffs and debuffs cast by the player on the target."] = true
L["Focus"] = FOCUS
L["Buffs and debuffs cast by the player on the focus."] = true
L["Totems"] = UNIT_NAME_ENEMY_TOTEMS
L["Totem tracker bars for Shaman players."] = true
L["Rune cooldown bars for Death Knight players."] = true
L["Notifications"] = true
L["Common class-specific notifications."] = true
L["Buff Tracker"] = true
L["Buff tracker string"] = "Buffs cast by the player on all targets (HoT timers)."
L["Debuff Tracker"] = true
L["Debuff tracker string"] = "Debuffs cast by the player on all targets (DoT timers)."
L["Timeline string"] = "Timeline icon configuration showing cooldowns for the player."
L["Create As Bars"] = true
L["Create bars string"] = "Create the selected bar groups using a bar-oriented format."
L["Create As Icons"] = true
L["Create icons string"] = "Create the selected bar groups using an icon-oriented format."
L["Configure string"] = "CREATE BAR GROUPS\nAre you sure you want to create the selected bar groups, overwriting existing bar groups with the same names?"
L["Reset selections."] = true
L["Link"] = true
L["Link standard group string"] = "Toggle linking selected bar groups to bar groups in other profiles with the same names. Linked bar groups share position, layout, appearance and timer options. This can be helpful when setting up multiple characters."
L["Delete the selected bar groups."] = true
L["Delete standard string"] = "DELETE BAR GROUPS\nAre you sure you want to delete the selected bar groups?"
L["Bar group anchor string"] = "Bar groups have anchors that show where bars will be displayed. " ..
	"Anchor tooltips list helpful shortcuts (e.g., change direction bars grow from the anchor, cycle through configuration choices, show test bars). " ..
	"You can left-click and drag anchors. " ..
	"You can right-click an anchor to lock it when you are satisfied with its position. " ..
	'Locked anchors are hidden--use the "Unlock All Anchors" button to show them again.\n'
L["Lock All Anchors"] = true
L["Lock and hide the anchors for all bar groups."] = true
L["Unlock All Anchors"] = true
L["Unlock and show the anchors for all bar groups."] = true
L["Bar Group Anchors and Test Mode"] = true
L["Toggle test mode for all bar groups."] = true

-- Defaults tab
L["Defaults"] = DEFAULTS
L["Defaults string"] = "Bars in a bar group share appearance options such as dimensions and fonts/textures. " ..
	"You can adjust defaults for these options with settings in this section. " ..
	"These settings are shared across all profiles to simplify use with multiple characters.\n"
L["Hide/Show Blizzard"] = true
L["Unit Frame"] = true
L["Hide/show default player unit frame."] = true
L["Buffs and Debuffs"] = true
L["Hide/show default user interface for buffs and debuffs."] = true
L["Cast Bar"] = true
L["Hide/show default player cast bar."] = true
L["Mirror Timers"] = true
L["Hide/show default user interface for mirror timers (e.g., breath bar)."] = true
L["Hide/show default user interface for combo points."] = true
L["Hide/show default user interface for chi."] = true
L["Hide/show default user interface for stagger."] = true
L["Hide/show default user interface for arcane charges."] = true
L["Hide/show default user interface for holy power."] = true
L["Hide/show default user interface for soul shards."] = true
L["Hide/show default user interface for insanity."] = true
L["Hide/show default user interface for totems."] = true
L["Hide/show default user interface for runes."] = true

L["XP and Reputation"] = true
L["Hide/show XP and reputation bars in the default user interface."] = true
L["Hide/show Azerite bar in the default user interface."] = true
L["Unit Frames"] = true
L["Hide/show default target unit frame."] = true
L["Hide/show default focus unit frame."] = true
L["Hide/show default pet unit frame."] = true
L["Hide/show default target's target unit frame."] = true
L["Hide/show default focus's target unit frame."] = true
L["Bar Configurations"] = true
L["Icon Configurations"] = true
L["Bar Width"] = true
L["Set width of bars."] = true
L["Bar Height"] = true
L["Set height of bars."] = true
L["Icon Size"] = true
L["Set width/height for icons."] = true
L["Scale"] = true
L["Set scale factor for bars and icons."] = true
L["Horizontal Spacing"] = true
L["Adjust horizontal spacing between bars."] = true
L["Vertical Spacing"] = true
L["Adjust vertical spacing between bars."] = true
L["Icon Inset"] = true
L["Set icon's horizontal inset from bar."] = true
L["Icon Offset"] = true
L["Set vertical offset between icon and bar."] = true
L["Reset Format"] = true
L["Reset format to default settings."] = true
L["RESET FORMAT\nAre you sure you want to reset the format options?"] = true
L["Fonts and Textures"] = true
L["Label Text"] = true
L["Font"] = true
L["Select font."] = true
L["Font Size"] = FONT_SIZE
L["Set font size."] = true
L["Opacity"] = OPACITY
L["Set text opacity."] = true
L["Color"] = true
L["Outline"] = true
L["Add black outline."] = true
L["Thick"] = true
L["Add thick black outline."] = true
L["Mono"] = true
L["Render font without antialiasing."] = true
L["Shadow"] = true
L["Show shadow with text."] = true
L["Border"] = true
L["Use icon border color for text."] = true
L["Time Text"] = true
L["Icon Text"] = true
L["Bars and Icons"] = true
L["Bar Foreground Texture"] = true
L["Select foreground texture for bars."] = true
L["Foreground Opacity"] = true
L["Set foreground opacity for bars."] = true
L["Bar Background Texture"] = true
L["Select background texture for bars."] = true
L["Background Opacity"] = true
L["Set background opacity for bars."] = true
L["Panels and Borders"] = true
L["Background Panel"] = true
L["Enable display of a background panel behind bar group."] = true
L["Panel Texture"] = true
L["Select texture to display in panel behind bar group."] = true
L["Adjust padding between bar group and the background panel and border."] = true
L["Set fill color for the panel."] = true
L["Background Border"] = true
L["Select border to display behind bar group (select None to disable border)."] = true
L["Adjust inset from the border to background panel's fill color."] = true
L["Adjust horizontal position of the panel."] = true
L["Adjust vertical position of the panel."] = true
L["Adjust width of the panel."] = true
L["Adjust height of the panel."] = true
L["Extra Width"] = true
L["Extra Height"] = true
L["Set color for the border."] = true
L["Bar Border"] = true
L["Select border for bars in the bar group (select None to disable border)."] = true
L["Adjust size of the border's edge."] = true
L["Adjust offset to the border from the bar."] = true
L["Set border's offset from the bar."] = true
L["Edge Size"] = true
L["Inset"] = true
L["Offset"] = true
L["Padding"] = true
L["Border Color"] = true
L["Panel Color"] = true
L["Foreground Saturation"] = true
L["Set saturation for foreground colors."] = true
L["Foreground Brightness"] = true
L["Set brightness for foreground colors."] = true
L["Background Saturation"] = true
L["Set saturation for background colors."] = true
L["Background Brightness"] = true
L["Set brightness for background colors."] = true
L["Opacity (Not Combat)"] = true
L["Set opacity for bars/icons when not in combat."] = true
L["Opacity (In Combat)"] = true
L["Set opacity for bars/icons when in combat."] = true
L["Icon Border Saturation"] = true
L["Set saturation for icon border colors."] = true
L["Icon Border Brightness"] = true
L["Set brightness for icon border colors."] = true
L["Reset Fonts/Textures"] = true
L["Reset fonts and textures to default settings."] = true
L["RESET FONTS/TEXTURES\nAre you sure you want to reset the font and texture options?"] = true
L["Standard Colors"] = true
L["Bar Colors:"] = true
L["Notify"] = true
L["Buff"] = true
L["Debuff"] = true
L["Cooldown"] = true
L["Buffs"] = true
L["Special Colors:"] = true
L["Curse"] = true
L["Magic"] = true
L["Disease"] = true
L["Poison"] = true
L["Reset Bar Colors"] = true
L["Reset bar colors back to default."] = true
L["RESET BAR COLORS\nAre you sure you want to reset bar colors back to default?"] = true
L["Reset Special Colors"] = true
L["Reset debuff colors back to default."] = true
L["RESET DEBUFF COLORS\nAre you sure you want to reset debuff colors back to default?"] = true
L["Reset Time Format"] = true
L["Reset time format to default settings."] = true
L["RESET TIME FORMAT\nAre you sure you want to reset the time format options?"] = true
L["Custom Time Format"] = true
L["If checked, add a custom time format created by a user-defined function to the end of the options list."] = true
L["Edit Function"] = true
L["Toggle display and edit for the user-defined function."] = true
L["User-Defined Function"] = true
L["Enter function that converts time in seconds to a formatted string."] = true
L["Reset Function"] = true
L["Reset user-defined function to default sample code."] = true
L["RESET CUSTOM TIME FORMAT FUNCTION\nAre you sure you want to reset the custom time format function to default sample code?"] = true
L["User-defined function does not return a string"] = true
L["User-defined function not valid"] = true
L["User-defined function is valid"] = true
L["OmniCC"] = true
L["Hide OmniCC"] = true
L["If checked, OmniCC counts are hidden on icons in all bar groups (requires /reload)."] = true
L["Tukui/ElvUI"] = true
L["If checked, bars are skinned with Tukui/ElvUI borders (requires /reload)."] = true
L["If checked, icons are also skinned with Tukui/ElvUI borders (requires /reload)."] = true
L["If checked, fonts are replaced with the normal font for Tukui/ElvUI (requires /reload)."] = true
L["Pixel Perfect"] = true
L["If checked, icons and bars will be adjusted for pixel perfect size and position (requires /reload)."] = true
L["Pixel Icon Border"] = true
L["If checked, icons will be displayed with a border one pixel wide (requires /reload)."] = true
L["Backdrop"] = true
L["Set color for icon backdrop (displayed only if pixel icon borders are enabled)."] = true
L["Icon Clock Edge"] = true
L["If checked, icon clock overlays will be displayed with an edge (requires /reload)."] = true
L["Skin Options"] = true
L["Hide Custom Border"] = true
L["By default, icons are displayed with a custom border and can be informatively colored using settings in the bar group Appearance tab. If this option is checked then custom borders are hidden."] = true
L["Trim Icon Texture"] = true
L["When hiding custom borders, the full icon texture is displayed by default but when this option is enabled the texture is trimmed to remove the outer edge."] = true
L["If checked, custom borders are automatically hidden and icons are skinned with Masque (requires /reload)."] = true
L["Use Masque"] = true
L["Masque"] = true
L["Enable setting highlights through Masque if it is loaded. This is not ideal for every skin which is why it can be disabled. Try both enabled and disabled settings and see which works best."] = true
L["Rectangular Icons"] = true
L["If checked, allow rectangular icons in icon-oriented configurations, using bar width to set icon's width (requires /reload)."] = true
L["Zoom Icons"] = true
L["If checked, rectangular icons are zoomed, rather than stretched (requires /reload)."] = true
L["Set default color for icon borders (displayed if None selected in Bar Color Scheme for Icon Border)."] = true
L["Color Normal Texture"] = true
L["If checked, icon border color is applied to the normal texture."] = true
L["Color Border Texture"] = true
L["If checked, icon border color is applied to the border texture."] = true
L["Sound Channel"] = true
L["Master"] = MASTER
L["If checked, sound is played in Master channel."] = true
L["SFX"] = true -- LEGION BUG
L["If checked, sound is played in Sound Effects channel."] = true
L["Music"] = VOICE_MUSIC
L["If checked, sound is played in Music channel."] = true
L["Ambience"] = VOICE_AMBIENCE
L["If checked, sound is played in Ambience channel."] = true

-- Spells tab
L["Spells"] = SPELLS
L["Spells string"] = "Spells have associated colors and labels which can be customized. " ..
	"Custom colors and labels are shared across all profiles to simplify use with multiple characters. " ..
	"You can also create spell lists and spell alerts and specify internal cooldowns and effect timers in this section.\n"
L["Colors and Labels"] = true
L["Spell Name"] = true
L["Enter a spell name (or numeric identifier, optionally preceded by # for a specific spell id)."] = true
L["Changed Spells"] = true
L["Select from list of spells with changed color, label, icon or sound."] = true
L["Spell Color"] = true
L["Select a standard color or click to set a custom color."] = true
L["Select a standard color or click to set a custom color (selecting None will restore spell's default color, if any)."] = true
L["Spell Label"] = true
L["Enter a label to be used by default with this spell."] = true
L["Spell Sound"] = true
L["Select sound to associate with the spell."] = true
L["Spell Expire Time"] = true
L["Set number of seconds for this spell to use with expiration sound and color special effects."] = true
L["Expire Color"] = true
L["Spell Icon"] = true
L["Enter a spell name (or numeric identifier, optionally preceded by # for a specific spell id) for an icon to be used by default with this spell."] = true
L["Warnings"] = true
L["Enable warnings about unrecognized spells."] = true
L["Reset"] = RESET
L["Reset color and label string"] = function(s) return string.format("Reset color, label, icon, sound, expire time and expire color for %s back to default.", s) end
L["Reset color and label confirm"] = function(s) return string.format("RESET SPELL\nAre you sure you want to reset the color, label, icon, sound, expire time and expire color for %s back to default?", s) end
L["Reset Colors"] = true
L["Reset spell colors back to defaults."] = true
L["RESET SPELL COLORS\nAre you sure you want to reset all spell colors back to defaults?"] = true
L["Reset Labels"] = true
L["Reset spell labels back to defaults."] = true
L["RESET SPELL LABELS\nAre you sure you want to reset all spell labels back to defaults?"] = true
L["Reset Icons"] = true
L["Reset spell icons back to defaults."] = true
L["RESET SPELL ICONS\nAre you sure you want to reset all spell icons back to defaults?"] = true
L["Reset Sounds"] = true
L["Reset spell sounds back to defaults."] = true
L["RESET SPELL SOUNDS\nAre you sure you want to reset all spell sounds back to defaults?"] = true
L["Reset Expire Times"] = true
L["Reset expire times back to defaults."] = true
L["RESET EXPIRE TIMES\nAre you sure you want to reset all expire times back to defaults?"] = true
L["Reset Expire Colors"] = true
L["Reset expire colors back to defaults."] = true
L["RESET EXPIRE TIMES\nAre you sure you want to reset all expire colors back to defaults?"] = true
L["Reset Spell"] = true

L["Spell Alerts"] = true
L["Enable showing spell alerts."] = true
L["Show spell alerts when player is in an arena."] = true
L["Show spell alerts when player is in a raid group."] = true
L["Show spell alerts when player is in a party."] = true
L["Show spell alerts when playing solo."] = true
L["Show spell alerts when player is in an instance."] = true
L["Show spell alerts when player is not in an instance."] = true
L["Labels Include Spell"] = true
L["Labels Include Caster"] = true
L["Labels Include Target"] = true
L["Show Realm Name"] = true
L["Units For Names"] = true
L["Caster = Target"] = true
L["Ignore Spell Targets List"] = true
L["Show Casting Alerts"] = true
L["Include the name of spell in label for spell alerts."] = true
L["Include the spell's caster in the label for the spell alert."] = true
L["Include the spell's target in the label for the spell alert."] = true
L["Include realm name for players on different servers."] = true
L["When possible, show unit ids instead of names."] = true
L["When spell's caster is same as spell's target, indicate with '<<'."] = true
L["Don't include targets for spell casts when spell is in the ignore spell targets list."] = true
L["Show alerts when spell casts start (targets are unknown until casts complete so filters may not apply)."] = true
L["Set how many seconds to show spell alerts."] = true
L["Ignore Targets"] = true
L["Spell Casts By Enemies"] = true
L["Spell Casts By Friends"] = true
L["Buffs On Enemies"] = true
L["Debuffs On Friends"] = true
L["If checked, spell alerts are shown as buffs on player. Note that these are excluded in bar groups by default."] = true
L["If checked, spell alerts are shown as debuffs on player. Note that these are excluded in bar groups by default."] = true
L["If checked, spell alerts are shown as player cooldowns. Note that these are excluded in bar groups by default."] = true
L["Show alerts for spell casts by enemies."] = true
L["Show alerts for spell casts by friends."] = true
L["Show alerts for buff spells cast on enemies."] = true
L["Show alerts for debuff spells cast on friends."] = true
L["Don't show alerts for spells in the selected spell list."] = true
L["Only show alerts for spells in the selected spell list."] = true
L["Is Target"] = true
L["Is Focus"] = true
L["Is NPC"] = true
L["If checked, show only the selected types of alerts (note alerts may match multiple types)."] = true
L["If checked, exclude all the selected types of alerts."] = true
L["Spell is being cast by the player's target."] = true
L["Spell is being cast by the player's focus."] = true
L["Spell is being cast by a player character."] = true
L["Spell is being cast by an NPC."] = true
L["Spell cast is targeting the player."] = true
L["Spell cast is targeting the player's target."] = true
L["Spell cast is targeting the player's focus."] = true

L["Internal Cooldowns"] = true
L["Enable detecting internal cooldowns."] = true
L["Internal Cooldowns Triggered By Buffs/Debuffs/Heals"] = true
L["Create a new internal cooldown triggered by a buff, debuff or heal spell."] = true
L["Enter spell name or numeric identifier for new internal cooldown."] = true
L["Enter comma-separated list of buff, debuff or heal spell names (or numeric identifiers) that reset the internal cooldown."] = true
L["If checked, test if buff, debuff or heal spell was cast by the player."] = true
L["If checked, test if buff, debuff or heal spell is on player and cast by anyone other than the player."] = true
L["Cooldown List"] = true
L["New Cooldown"] = true
L["Enter Spell Name or ID"] = true
L["Cancel creating a new internal cooldown."] = true
L["Delete Cooldown"] = true
L["Delete the selected internal cooldown."] = true
L["Delete cooldown string"] = "DELETE COOLDOWN\nAre you sure you want to delete the selected internal cooldown?"
L["Enter duration in seconds."] = true
L["Enable detecting this internal cooldown."] = true
L["Cast On Player"] = true
L["Reset List"] = true
L["Reset Cooldowns"] = true
L["Reset all internal cooldowns back to defaults."] = true
L["RESET COOLDOWNS\nAre you sure you want to reset all internal cooldowns back to defaults?"] = true
L["Effect Timers Triggered By Spell Casts"] = true
L["Enable detecting spell effects."] = true
L["Spell Effect List"] = true
L["New Spell Effect"] = true
L["Enter a new spell effect triggered by a successful spell cast."] = true
L["Enter spell name or numeric identifier that, when cast, will trigger a new spell effect."] = true
L["Cancel creating a new spell effect."] = true
L["If checked, spell effect is a buff."] = true
L["If checked, spell effect is a debuff."] = true
L["If checked, spell effect is a cooldown."] = true
L["Delete Spell Effect"] = true
L["Delete the selected spell effect."] = true
L["Delete effect string"] = "DELETE SPELL EFFECT\nAre you sure you want to delete the selected spell effect?"
L["Enable detecting this spell effect."] = true
L["Renew"] = true
L["If checked, spell effect is renewed if spell is cast again while effect is active."] = true
L["If checked, include name of caster in the label if spell effect is a buff or debuff."] = true
L["Enter spell name or numeric identifier for spell to be associated with this effect (default is to use spell that triggers the effect)."] = true
L["Required Talent"] = true
L["Enter name or numeric identifier for talent required for effect to happen (leave blank if no talent required)."] = true
L["Required Buff"] = true
L["Enter name or numeric identifier for buff required to be active on player for effect to happen (leave blank if no buff required)."] = true
L["Required Condition"] = true
L["Enter name of condition required to be true for effect to happen (leave blank if no condition required)."] = true
L["Optional Buff"] = true
L["Enter name or numeric identifier for buff that changes the duration of the effect when active on player (leave blank if no buff required)."] = true
L["Optional Duration"] = true
L["Enter duration of spell effect when optional buff is active on player."] = true
L["If checked, spell must be cast by the player to trigger the spell effect."] = true
L["If checked, spell must be cast by the player's pet to trigger the spell effect."] = true
L["If checked, spell must be cast by the target to trigger the spell effect."] = true
L["If checked, spell must be cast by the focus to trigger the spell effect."] = true
L["If checked, spell must be cast by anyone other than the player or pet to trigger the spell effect."] = true
L["If checked, spell must be cast by the player or pet to trigger the spell effect."] = true
L["If checked, trigger the spell effect if the spell is cast by anyone, including player."] = true
L["Spell Lists"] = true
L["Spell List"] = true
L["Spell List #1"] = true
L["Spell List #2"] = true
L["Spell List #3"] = true
L["Spell List #4"] = true
L["Spell List #5"] = true
L["New Spell List"] = true
L["Create a new spell list (or select an existing one by name)."] = true
L["Copy Spell List"] = true
L["Copy the selected spell list into a new or existing spell list."] = true
L["Enter Spell List Name"] = true
L["Enter name for either a new or existing spell list."] = true
L["Cancel creating a new spell list."] = true
L["Delete Spell List"] = true
L["Delete the selected spell list."] = true
L["Delete spell list string"] = "DELETE SPELL LIST\nAre you sure you want to delete the selected spell list?"
L["Enter Spell"] = true
L["Delete the selected spell from the list."] = true
L["Reset the spell list."] = true
L['RESET\nAre you sure you want to reset the spell list?'] = true

-- Bar Groups tab
L["Bar Groups"] = true
L["Bar Group"] = true
L["New Custom Group"] = true
L["Create a new bar group with manually added bars."] = true
L["New Auto Group"] = true
L["Create a new bar group with automatically displayed bars."] = true
L["Enter Custom Group Name"] = true
L["Enter name of new custom bar group."] = true
L["Invalid name."] = true
L["Enter Auto Group Name"] = true
L["Enter name of new auto bar group."] = true
L["Cancel"] = true
L["Cancel creating a new bar group."] = true
L["Delete Bar Group"] = true
L["Delete the selected bar group."] = true
L["Delete bar group string"] = function(s) return string.format("DELETE BAR GROUP\nAre you sure you want to delete the %s bar group?", s) end

-- Bar Groups > General tab
L["General"] = GENERAL
L["Settings"] = SETTINGS
L["General Settings"] = true
L["Enable Bar Group"] = true
L["Enable bar group string"] = "If checked, the bar group is enabled and its anchor and bars will be displayed, " ..
	"otherwise the bar group is disabled and neither anchor nor bars will be displayed."
L["Merge Bar Group"] = true
L["Merge bar group string"] = "If checked, merge bars from this bar group into another bar group. " ..
	"Bars are generated based on this bar group's custom or auto settings, including \"Show When\" and timer options, " ..
	"but are sorted and displayed using the other bar group's layout and appearance settings."
L["Rename Bar Group"] = true
L["New Name"] = true
L["Enter new name for the bar group."] = true
L["Sharing"] = true
L["Link Settings"] = true
L["Load Settings"] = true
L["Save Settings"] = true
L["Link settings string"] = "If checked, the bar group's position, layout, appearance, and timer options are linked " ..
	"to bar groups in other profiles with the same name. Shared settings are loaded when a character " ..
	"enters the world and are saved at logout. Be careful enabling this feature since it will overwrite " ..
	"current settings if there is a linked bar group with same name in another profile. If you want to share your current settings, " ..
	"overwriting any previously shared settings, then click the Save Settings button before enabling this option."
L["Confirm link string"] = "LINK BAR GROUP\nAre you sure you want to overwrite current settings?"
L["Confirm unlink string"] = "LINK BAR GROUP\nAre you sure you no longer want to link settings for this bar group?"
L["Click to save to the shared settings used by bar groups with same name in other profiles."] = true
L["Click to load the shared settings used by bar groups with same name in other profiles."] = true
L["Confirm load string"] = "LOAD SETTINGS\nAre you sure you want to overwrite current settings for this bar group?"
L["No linked settings string"] = "LOAD SETTINGS\nThere are no shared settings for this bar group."
L["Confirm save string"] = "SAVE SETTINGS\nAre you sure you want to overwrite the shared settings used by bar groups with same name in other profiles?"
L["Link Custom Bars"] = true
L["Load Custom Bars"] = true
L["Save Custom Bars"] = true
L["Link bars string"] = "If checked, the bar group's custom bars are linked " ..
	"to bar groups in other profiles with the same name. Shared custom bars are loaded when a character " ..
	"enters the world and are saved at logout. Be careful enabling this feature since it will overwrite " ..
	"current custom bars if there is a linked bar group with same name in another profile. If you want to share your current custom bars, " ..
	"overwriting any previously shared custom bars, then click the Save Custom Bars button before enabling this option."
L["Confirm link bars string"] = "LINK BARS\nAre you sure you want to overwrite current custom bars?"
L["Confirm unlink bars string"] = "LINK BARS\nAre you sure you no longer want to link the custom bars for this bar group?"
L["Click to load the shared custom bars used by bar groups with same name in other profiles."] = true
L["Click to save to the shared custom bars used by bar groups with same name in other profiles."] = true
L["Confirm load bars string"] = "LOAD CUSTOM BARS\nAre you sure you want to overwrite current custom bars for this bar group?"
L["No linked bars string"] = "LOAD CUSTOM BARS\nThere are no shared custom bars for this bar group."
L["Confirm save bars string"] = "SAVE CUSTOM BARS\nAre you sure you want to overwrite the shared custom bars used by bar groups with same name in other profiles?"
L["Bar Group To Merge Into"] = true
L["Select a bar group to merge into."] = true
L["Sort Order"] = true
L["A to Z"] = true
L["If checked, sort in ascending alphabetical order starting at bar closest to the anchor."] = true
L["Time Left"] = true
L["If checked, sort by time left in ascending order starting at bar closest to the anchor."] = true
L["Duration"] = true
L["If checked, sort by overall duration in ascending order starting at bar closest to the anchor."] = true
L["Creation"] = true
L["If checked, show bars in order created with oldest bar closest to the anchor."] = true
L["Custom"] = true
L["If checked, allow manually setting the order of bars."] = true
L["Reverse Order"] = true
L['If checked, reverse the sort order (e.g., "A to Z" becomes "Z to A").'] = true
L["Also Time Left"] = true
L['If checked, before applying selected sort order, first sort by time left.'] = true
L["Also Player First"] = true
L['If checked, after applying selected sort order, sort bars with actions by player first.'] = true
L["Show When"] = true
L["If checked, bar group is shown when the player is in combat."] = true
L["If checked, bar group is shown when the player is out of combat."] = true
L["Resting"] = true
L["If checked, bar group is shown when the player is resting."] = true
L["Mounted"] = true
L["If checked, bar group is shown when the player is mounted."] = true
L["Vehicle"] = true
L["If checked, bar group is shown when the player is in a vehicle."] = true
L["Enemy"] = ENEMY
L["If checked, bar group is shown when the target is an enemy."] = true
L["Friendly"] = FRIENDLY
L["If checked, bar group is shown when the target is friendly."] = true
L["Focus=Target"] = true
L["If checked, bar group is shown when focus is same as target."] = true
L["Solo"] = true
L["If checked, bar group is shown when the player is not in a party or raid."] = true
L["If checked, bar group is shown when the player is in a party."] = true
L["If checked, bar group is shown when the player is in a raid."] = true
L["If checked, bar group is shown when the player is in a 5-man or raid instance."] = true
L["If checked, bar group is shown when the player is not in a 5-man or raid instance."] = true
L["If checked, bar group is shown when the player is in an arena."] = true
L["If checked, bar group is shown when the player is in a battleground."] = true
L["If checked, bar group is shown when player is flying on a taxi."] = true
L["If checked, bar group is shown when the player is in a pet battle."] = true
L["Blizzard Buffs Enabled"] = true
L["If checked, the bar group is shown if the default user interface for buffs is enabled."] = true
L["Blizzard Buffs Disabled"] = true
L["If checked, the bar group is shown if the default user interface for buffs is disabled."] = true
L["Condition Is True"] = true
L["If checked, bar group is shown only when the selected condition is true."] = true
L["Condition"] = true
L["Player Class"] = true
L["Player Specialization"] = true
L["Start Spell Sound"] = true
L["Play associated spell sound, if any, when bar starts (spell sounds are set up on Spells tab)."] = true
L["Alternative Start Sound"] = true
L["Select sound to play when there is no associated spell sound (or spell sound is not enabled)."] = true
L["Replay"] = true
L["Enable replay of start sound (after a specified amount of time) while bar is active."] = true
L["Replay Time"] = true
L["Replay Start Sound"] = true
L["Set number of seconds between replays of start sound."] = true
L["Finish Spell Sound"] = true
L["Play associated spell sound, if any, when bar finishes (spell sounds are set up on Spells tab)."] = true
L["Alternative Finish Sound"] = true
L["Expire Spell Sound"] = true
L["Play associated spell sound, if any, when bar is about to expire (spell sounds are set up on Spells tab)."] = true
L["Alternative Expire Sound"] = true
L["Ready Spell Sound"] = true
L["Play associated spell sound, if any, when ready bar is shown (spell sounds are set up on Spells tab)."] = true
L["Alternative Ready Sound"] = true
L["Expire Time"] = true
L["Set number of seconds before expiration to trigger sound and color options."] = true
L["Expire Percentage"] = true
L["Set minimum percentage of duration for the Expire Time setting (use whichever is longer)."] = true
L["Minimum Duration"] = true
L["Set minimum duration in minutes required to trigger expiration options."] = true
L["Expire Colors"] = true
L["Enable color changes for expiring bars."] = true
L["Set bar color for when about to expire (set invisible opacity to disable color change)."] = true
L["Set label color for when bar is about to expire (set invisible opacity to disable color change)."] = true
L["Set time color for when bar is about to expire (set invisible opacity to disable color change)."] = true
L["Tick"] = true
L["Set color for expire time tick (set invisible opacity to disable showing tick on bar)."] = true
L["Shine"] = true
L["Sparkle"] = true
L["Effect Time"] = true
L["Set number of seconds to show start effects (set to 0 for unlimited time)."] = true
L["Pulse"] =  true
L["Glow"] = true
L["Enable shine effect when bar is started."] = true
L["Enable sparkle effect when bar is started."] = true
L["Enable glow effect when bar is started."] = true
L["Enable flashing when bar is started."] = true
L["Desaturate icon when bar is started."] = true
L["Enable combat text when bar is started."] = true
L["Set color for combat text."] = true
L["Set combat text to show as critical."] = true
L["Filters For Start Effects"] = true
L["All"] = true
L["Dispel"] = true
L["Apply special effects to all bars when started."] = true
L["Apply special effects to buffs and debuffs cast by the player."] = true
L["Apply special effects to buffs and debuffs cast by the player's pet."] = true
L["Apply special effects to buffs and debuffs cast by a boss."] = true
L["Apply special effects to debuffs that the player can dispel."] = true
L["Apply special effects to buffs that the player can steal."] = true
L["Apply special effects to poison debuffs."] = true
L["Apply special effects to curse debuffs."] = true
L["Apply special effects to magic buffs and debuffs."] = true
L["Apply special effects to disease debuffs."] = true
L["Apply special effects to enrage buffs."] = true
L["Delayed Effects"] = true
L["Enable fade effect when bar is started."] = true
L["Enable hiding timer bars when started (does not hide bars with unlimited duration)."] = true
L["Set number of seconds to wait before showing start effects."] = true
L["Desaturate"] = true
L["Combat Text"] = true
L["Expire Effects"] = true
L["Set number of seconds before timer bar finishes to show expire effects."] =  true
L["Set number of seconds before timer bar finishes to show expire effects (may be overridden by spell expire time, see bar group expire effects options)."] = true
L["Set percentage of duration before timer finishes for expire special effects. When both expire time and percentage are set then use whichever is longer."] = true
L["Set minimum duration in minutes required to trigger expire special effects."] = true
L["Enable shine effect when bar is expiring."] = true
L["Enable sparkle effect when bar is expiring."] = true
L["Enable glow effect when bar is expiring."] = true
L["Enable flashing when bar is expiring."] = true
L["Enable icon pulse when bar is expiring."] = true
L["Desaturate icon when bar is expiring."] = true
L["Enable combat text when bar is expiring."] = true
L["Enable warning in combat text for expiring bars."] = true
L["Enable shine effect when bar is finishing."] = true
L["Enable sparkle effect when bar is finishing."] = true
L["Enable icon pulse when bar is finishing."] = true
L["Splash"] = true
L["Enable splash effect when bar is finished."] = true
L["Ghost"] = true
L["Enable ghost effect when bar is finished (i.e., continue to show after would normally disappear)."] = true
L["Set number of seconds to show special effects at finish."] = true
L["Enable combat text when bar is finished."] = true
L["Critical"] = true
L["Enable combat text warning as critical."] = true
L["Set color for combat text warning."] = true
L["Enable combat text when ready bar is shown."] = true
L["Enable shine effect when ready bar is shown."] = true
L["Enable sparkle effect when ready bar is shown."] = true
L["Enable icon pulse when ready bar is shown."] = true
L["Enable glow effect when ready bar is shown."] = true
L["Enable flashing when ready bar is shown."] = true
L["Set number of seconds to show special effects when ready bar is shown (set to 0 for unlimited time)."] = true
L["started"] = true
L["expiring"] = true
L["finished"] = true
L["ready"] = true
L["Miscellaneous Options"] = true
L["Frame Strata"] = true
L["Frame strata string"] = "Select the general layering strata for the frame, making the bar group appear either above or behind other UI elements. Note that this can interfere with other capabilities, such as tooltips and right-click cancelling buffs."
L["Lock Anchor"] = true
L["Lock and hide the anchor for the bar group."] = true
L["Unlock Anchor"] = true
L["Unlock and show the anchor for the bar group."] = true
L["Non-Interactive"] = true
L["If checked, the bar group is non-interactive and doesn't show tooltips or respond to clicks."] = true
L["Only Icons Interact"] = true
L["If checked, only icons show tooltips and respond to clicks, otherwise entire bar does."] = true
L["Tooltip Anchor"] = true
L["Tooltip anchor string"] = "Select tooltip anchor point (\"DEFAULT\" adjusts tooltip anchors automatically). Note that addons like TipTac may override Raven's tooltip settings."
L["Combat Tooltips"] = true
L["If checked, tooltips are shown during combat."] = true
L["Caster"] = true
L["If checked, tooltips include caster for buffs and debuffs when known."] = true
L["Show Headers"] = true
L["When showing all buffs or debuffs cast by player, add headers for each affected target."] = true
L["Sort Target First"] = true
L["When showing all buffs or debuffs cast by player, sort ones for target first."] = true
L["Non-Target Opacity"] = true
L["When showing all buffs or debuffs cast by player, set opacity for ones not on target."] = true
L["Targets"] = true
L["When showing all buffs or debuffs cast by player without headers, show target names in labels."] = true
L["When showing all buffs or debuffs cast by player without headers, show spell names in labels."] = true
L["When showing all buffs or debuffs cast by player without headers, keep spacing between groups."] = true
L["Clock Direction"] = true
L["Set empty/fill direction for clock animations on icons."] = true
L["External Fader"] = true
L["Support external fader addons by disabling bar group opacity options (requires /reload)."] = true
L["Spell ID"] = true
L["If checked, holding down control and alt keys will add spell ID to tooltips when known."] = true
L["Start Effects"] = true
L["Expire Effects"] = true
L["Finish Effects"] = true
L["Ready Effects"] = true
L["Special Effects"] = true
L["Pulse At Start"] = true
L["Enable icon pulse when bar is started."] = true
L["Pulse When Expiring"] = true
L["Enable icon pulse when bar is expiring."] = true
L["Shine At Start"] = true
L["Enable icon shine effect when bar is started."] = true
L["Desaturate Ready Bar Icon"] = true
L["Desaturate icon for ready bar."] = true
L["Hide After Start"] = true
L["Enable hide after start for timer bars (does not hide bars with unlimited duration)."] = true
L["Fade After Start"] = true
L["Enable fade after start (i.e., switch to fade opacity after a delay)."] = true
L["Ghost When Expiring"] = true
L["Enable ghost bar/icon (i.e., continue to show for delay period after would normally disappear)."] = true
L["Ghost Time"] = true
L["Delay Time"] = true
L["Set number of seconds before bar (or ghost) will hide or fade."] = true
L["Flash Ready Bar"] = true
L["Enable flashing of ready bars."] = true
L["Flash When Expiring"] = true
L["Enable flashing of expiring bars."] = true
L["Flash Time"] = true
L["Set number of seconds before expiration that bar should start flashing."] = true
L["Use Spell Expire Time"] = true
L["Use spell's expire time when set on the Spells tab."] = true
L["Use Spell Expire Color"] = true
L["Use spell's expire color when set on the Spells tab."] = true
L["If checked, bar group special effects are enabled."] = true
L["If checked, bar-specific special effects are enabled."] = true
L["Only Bar Special Effects"] = true
L["If checked, only show bar-specific special effects, otherwise also show bar group special effects."] = true
L["Customize"] = true
L["If checked, enable customization of special effects for this bar group."] = true
L["If checked, enable customization of special effects for this bar."] = true
L["Set color for shine effects."] = true
L["Set color for sparkle effects."] = true
L["Set color for glow effects."] = true
L["Expire Bar Color Only Changes Foreground"] = true
L["If checked, expire bar color effect only changes foreground color, otherwise it changes both foreground and background colors."] = true
L["Flash Period"] = true
L["Set number of seconds for period to be used in flash effects."] = true
L["Flash Percentage"] = true
L["Set minimum opacity during flash effects as percentage of bar's current opacity."] = true
L["Combat Text Includes Bar Group"] = true
L["If checked, combat text includes the name of the bar group."] = true

-- Bar Groups > Custom Bars tab
L["Custom Bars"] = true
L["New"] = true
L["Create a new bar."] = true
L["Delete the selected bar."] = true
L['DELETE BAR\nAre you sure you want to delete the selected bar?'] = true

-- Bar Groups > Buffs tab
L["Auto Buffs"] = true
L['Enable automatically displaying bars for buffs that match these settings.'] = true
L["All Cast By Player"] = true
L['Include all buffs cast by player on others.'] = true
L["Include Totems"] = true
L['Include active totems as buffs.'] = true
L["Action On"] = true
L["If checked, only add bars for buffs if they are on the player."] = true
L["If checked, only add bars for buffs if they are on the player's pet."] = true
L["If checked, only add bars for buffs if they are on the target."] = true
L["If checked, only add bars for buffs if they are on the focus."] = true
L["Exclude On"] = true
L["If checked, exclude buffs if they are on the player."] = true
L["If checked, exclude buffs if they are on the player's pet."] = true
L["If checked, exclude buffs if they are on the target."] = true
L["If checked, exclude buffs if they are on the focus."] = true
L["Mouseover"] = true
L["Pet's Target"] = true
L["Target's Target"] = true
L["Focus's Target"] = true
L["Player Or Pet"] = true
L["Party1"] = true
L["Party2"] = true
L["Party3"] = true
L["Party4"] = true
L["Boss1"] = true
L["Boss2"] = true
L["Boss3"] = true
L["Boss4"] = true
L["Boss5"] = true
L["Arena1"] = true
L["Arena2"] = true
L["Arena3"] = true
L["Arena4"] = true
L["Arena5"] = true
L["If checked, only add bars for buffs if they are on the mouseover unit."] = true
L["If checked, only add bars for buffs if they are on the pet's target."] = true
L["If checked, only add bars for buffs if they are on the target's target."] = true
L["If checked, only add bars for buffs if they are on the focus's target."] = true
L["If checked, only add bars for buffs if they are on the specified party unit."] = true
L["If checked, only add bars for buffs if they are on the specified boss unit."] = true
L["If checked, only add bars for buffs if they are on the specified arena unit."] = true
L["If checked, only add bars for buffs if cast by the player."] = true
L["If checked, only add bars for buffs if cast by the player's pet."] = true
L["If checked, only add bars for buffs if cast by the target."] = true
L["If checked, only add bars for buffs if cast by the focus."] = true
L["If checked, only add bars for buffs if cast by anyone other than the player or pet."] = true
L["If checked, only add bars for buffs if cast by player or pet."] = true
L["If checked, add bars for buffs if cast by anyone, including player."] = true
L["Other"] = OTHER
L["Anyone"] = true
L["Include By Type"] = true
L["Include buff types string"] = "If checked, include only the selected types of buffs (note buffs may match multiple types)."
L["Exclude By Type"] = true
L["Exclude buff types string"] = "If checked, exclude all the selected types of buffs (note buffs may match multiple types)."
L["Mounts"] = true
L['Include mount buffs.'] = true
L['Exclude mount buffs.'] = true
L["Stealable"] = true
L["Tracking"] = true
L['Include buffs that mages can spellsteal.'] = true
L['Exclude buffs that mages can spellsteal.'] = true
L['Include magic buffs but not those considered stealable (magic buffs can usually be removed with abilities like Purge).'] = true
L['Exclude magic buffs except those considered stealable.'] = true
L['Include buffs not selected by other types.'] = true
L['Exclude buffs not selected by other types.'] = true
L['Include buffs cast by boss.'] = true
L['Exclude buffs cast by boss.'] = true
L["NPC"] = true
L['Include buffs cast by an NPC (note: only valid while caster is selected, such as when checking target of target).'] = true
L['Include buffs cast by a vehicle (note: only valid while caster is selected, such as when checking target of target).'] = true
L['Exclude buffs cast by an NPC (note: only valid while caster is selected, such as when checking target of target).'] = true
L['Exclude buffs cast by a vehicle (note: only valid while caster is selected, such as when checking target of target).'] = true
L["Enrage"] = true
L['Include enrage buffs.'] = true
L['Exclude enrage buffs.'] = true
L["Castable"] = true
L['Include buffs that the player can cast.'] = true
L['Exclude buffs that the player can cast.'] = true
L["Include buffs from effect timers triggered by a spell cast."] = true
L["Exclude buffs from effect timers triggered by a spell cast."] = true
L["Include buffs from spell alerts."] = true
L["Exclude buffs from spell alerts."] = true
L["Weapon Buffs"] = true
L["Include weapon buffs."] = true
L["Exclude weapon buffs."] = true
L["Tabard"] = true
L['Include buffs from equipped tabard (player only).'] = true
L['Exclude buffs from equipped tabard (player only).'] = true
L["Minions"] = true
L['Include timers for warlock minions (player only).'] = true
L['Exclude timers for warlock minions (player only).'] = true
L["Include tracking buffs."] = true
L["Exclude tracking buffs."] = true
L["Resources"] = true
L["Include buffs for resources (e.g., monk's Chi)."] = true
L["Exclude buffs for resources (e.g., monk's Chi)."] = true
L["Filter List"] = true
L["Black List"] = true
L["White List"] = true
L["Use Spell List"] = true
L["If checked, filter list includes spells in specified spell list (these are set up on the Spells tab)."] = true
L["If checked, don't display any buffs that are in the filter list."] = true
L["If checked, only display buffs that are in the filter list."] = true
L["If checked, the filter list is shared with bar groups in other profiles with the same name."] = true
L["Enter Buff"] = true
L["Enter a spell name (or numeric identifier, optionally preceded by # for a specific spell id) for a buff to be added to the filter list."] = true
L["Delete the selected buff from the filter list."] = true
L["Reset the buff filter list."] = true
L['RESET\nAre you sure you want to reset the buff filter list?'] = true
L["Filter Bar Group"] = true
L["Select filter bar group."] = true
L["Filter buff bar group string"] = "If checked, don't display buffs also in selected bar group. If custom bar group selected, don't display buffs in its custom bar list. If auto bar group selected, don't display buffs in its filter list."

-- Bar Groups > Debuffs tab
L["Auto Debuffs"] = true
L['Enable automatically displaying bars for debuffs that match these settings.'] = true
L['Include all debuffs cast by player on others.'] = true
L["Only Show Dispellable"] = true
L['If check, only show debuffs that can be dispelled by the player.'] = true
L["If checked, exclude debuffs if they are on the player."] = true
L["If checked, exclude debuffs if they are on the player's pet."] = true
L["If checked, exclude debuffs if they are on the target."] = true
L["If checked, exclude debuffs if they are on the focus."] = true
L["If checked, only add bars for debuffs if they are on the player."] = true
L["If checked, only add bars for debuffs if they are on the player's pet."] = true
L["If checked, only add bars for debuffs if they are on the target."] = true
L["If checked, only add bars for debuffs if they are on the focus."] = true
L["If checked, only add bars for debuffs if they are on the mouseover unit."] = true
L["If checked, only add bars for debuffs if they are on the pet's target."] = true
L["If checked, only add bars for debuffs if they are on the target's target."] = true
L["If checked, only add bars for debuffs if they are on the focus's target."] = true
L["If checked, only add bars for debuffs if they are on the specified party unit."] = true
L["If checked, only add bars for debuffs if they are on the specified boss unit."] = true
L["If checked, only add bars for debuffs if they are on the specified arena unit."] = true
L["If checked, only add bars for debuffs if cast by the player."] = true
L["If checked, only add bars for debuffs if cast by the player's pet."] = true
L["If checked, only add bars for debuffs if cast by the target."] = true
L["If checked, only add bars for debuffs if cast by the focus."] = true
L["If checked, only add bars for debuffs if cast by anyone other than the player or pet."] = true
L["If checked, only add bars for debuffs if cast by player or pet."] = true
L["If checked, add bars for debuffs if cast by anyone, including player."] = true
L["If checked, don't display any debuffs that are in the filter list."] = true
L["If checked, only display debuffs that are in the filter list."] = true
L["Dispellable"] = true
L["Include debuff types string"] = "If checked, include only the selected types of buffs (note debuffs may match multiple types)."
L["Exclude debuff types string"] = "If checked, exclude all the selected types of debuffs (note debuffs may match multiple types)."
L['Include other debuffs not selected with filter types.'] = true
L['Include debuffs that the player can dispel.'] = true
L['Include debuffs cast by boss.'] = true
L['Include poison debuffs.'] = true
L['Include curse debuffs.'] = true
L['Include magic debuffs.'] = true
L['Include disease debuffs.'] = true
L["Include enrage debuffs."] = true
L['Include debuffs cast by an NPC (note: only valid while caster is selected, such as when checking target of target).'] = true
L['Include debuffs cast by a vehicle (note: only valid while caster is selected, such as when checking target of target).'] = true
L['Include debuffs that the player can cast.'] = true
L['Include debuffs that the player can cast.'] = true
L["Include debuffs from effect timers triggered by a spell cast."] = true
L["Include debuffs from spell alerts."] = true
L['Exclude other debuffs not selected with filter types.'] = true
L['Exclude debuffs that the player can dispel.'] = true
L['Exclude debuffs cast by boss.'] = true
L['Exclude poison debuffs.'] = true
L['Exclude curse debuffs.'] = true
L['Exclude magic debuffs.'] = true
L['Exclude disease debuffs.'] = true
L["Exclude enrage debuffs."] = true
L['Exclude debuffs cast by an NPC (note: only valid while caster is selected, such as when checking target of target).'] = true
L['Exclude debuffs cast by a vehicle (note: only valid while caster is selected, such as when checking target of target).'] = true
L['Exclude debuffs that the player can cast.'] = true
L["Exclude debuffs from effect timers triggered by a spell cast."] = true
L["Exclude debuffs from spell alerts."] = true
L['Exclude debuffs that the player can cast.'] = true
L["If checked, the debuff filter list is shared with bar groups in other profiles with the same name."] = true
L["Enter Debuff"] = true
L["Enter a spell name (or numeric identifier, optionally preceded by # for a specific spell id) for a debuff to be added to the filter list."] = true
L["Delete the selected debuff from the filter list."] = true
L["Reset the debuff filter list."] = true
L['RESET\nAre you sure you want to reset the debuff filter list?'] = true
L["Filter debuff bar group string"] = "If checked, don't display debuffs also in selected bar group. If custom bar group selected, don't display debuffs in its custom bar list. If auto bar group selected, don't display debuffs in its filter list."

-- Bar Groups > Cooldowns tab
L["Auto Cooldowns"] = true
L['Enable automatically displaying bars for cooldowns that match these settings.'] = true
L["Action By"] = true
L["If checked, only add bars for cooldowns associated with the player."] = true
L["If checked, only add bars for cooldowns associated with the player's pet."] = true
L["If checked, add bars for cooldowns cast by either player or player's pet."] = true
L["Cooldown Types"] = true
L["Include spell cooldowns."] = true
L["Trinkets"] = true
L["Include cooldowns for equipped trinkets."] = true
L["Include internal cooldowns triggered by a buff or debuff."] = true
L["Effect Timers"] = true
L["Include effect timers triggered by a spell cast."] = true
L["Include spell alerts."] = true
L["Potions/Elixirs"] = true
L["Include shared potion/elixir cooldowns (an item subject to the shared cooldown must be in your bags in order for the cooldown to be detected)."] = true
L["Include cooldowns not selected by other types."] = true
L["Shared Cooldowns"] = true
L["Grimoire of Service"] = true
L["Summon Infernals"] = true
L["If checked, only show one cooldown for warlock Grimoire of Service."] = true
L["If checked, only show one cooldown for warlock infernal and doomguard."] = true
L["Filter Cooldowns"] = true
L["If checked, don't display any cooldowns that are in the filter list."] = true
L["If checked, only display cooldowns that are in the filter list."] = true
L["If checked, the cooldown filter list is shared with bar groups in other profiles with the same name."] = true
L["Enter Cooldown"] = true
L["Enter a spell name (or numeric identifier, optionally preceded by # for a specific spell id) for a cooldown to be added to the filter list."] = true
L["Delete the selected cooldown from the filter list."] = true
L["Reset the cooldown filter list."] = true
L['RESET\nAre you sure you want to reset the cooldown filter list?'] = true
L["Filter cooldown bar group string"] = "If checked, don't display cooldowns also in selected bar group. If custom bar group selected, don't display cooldowns in its custom bar list. If auto bar group selected, don't display cooldowns in its filter list."

-- Bar Groups > Layout tab
L["Layout"] = true
L["Configuration"] = true
L["Bar Configuration"] = true
L["If checked, use a bar-oriented configuration."] = true
L["Icon Configuration"] = true
L["If checked, use an icon-oriented configuration."] = true
L["Options"] = true
L["Select a configuration option for bars or icons."] = true
L["Direction"] = true
L["If checked, stripe is above the anchor, otherwise it is below the anchor."] = true
L["If checked, grow up or to the right, otherwise grow down or to the left."] = true
L["Copy Layout From"] = true
L["Select bar group to copy all layout settings from."] = true
L["Segment Options"] = true
L["Number Of Segments"] = true
L["Set the number of segments to display for the bar."] = true
L["Allow Override"] = true
L["If checked, segment options may be overridden by a custom bar's settings."] = true
L["Segment Spacing"] = true
L["Set spacing between segments."] = true
L["Advanced Settings"] = true
L["Enable advanced settings to experiment with unusual segment arrangements."] = true
L["Curvature"] = true
L["Adjust curvature of segment arrangement."] = true
L["Rotation"] = true
L["Adjust rotation of segment arrangement."] = true
L["Circles"] = true
L["If checked, circles are shown instead of rectangular segments."] = true
L["Diamonds"] = true
L["If checked, diamonds are shown instead of rectangular segments."] = true
L["Triangles"] = true
L["If checked, triangles are shown instead of rectangular segments."] = true
L["Trapezoids"] = true
L["If checked, trapezoids are shown instead of rectangular segments."] = true
L["Hide Empty Segments"] = true
L["If checked, empty segments are hidden."] = true
L["Fade Partial Segments"] = true
L["If checked, fade the foreground color for partial segments to indicate how much is left."] = true
L["Shrink Partial Width"] = true
L["If checked, shrink the width of the foreground for partial segments to indicate how much is left."] = true
L["Shrink Partial Height"] = true
L["If checked, shrink the height of the foreground for partial segments to indicate how much is left."] = true
L["Color Gradient"] = true
L["If checked and there are at least two segments, segments are customized with a color gradient, otherwise they use the bar's foreground color."] = true
L["Color All Together"] = true
L["Apply gradient to all segments based on how many are showing, otherwise color each segment individually."] = true
L["Start"] = true
L["Set start color for the gradient."] = true
L["End"] = true
L["Set end color for the gradient."] = true
L["Set color, including opacity, of the border around each segment."] = true
L["Timeline Options"] = true
L["Timeline"] = true
L["Width"] = true
L["Set width of the timeline."] = true
L["Height"] = true
L["Set height of the timeline."] = true
L["Set maximum duration represented on the timeline in seconds."] = true
L["Exponent"] = true
L["Set exponent factor for timeline to adjust time scale."] = true
L["Label List"] = true
L['Enter comma-separated list of times to show as labels on the timeline (times are in seconds unless you include "m", which is included in the label, or "M", which is hidden, for minutes).'] = true
L["Texture"] = true
L["Select texture for the timeline."] = true
L["Set opacity for the timeline."] = true
L["Timeline Color"] = true
L["Set color for the timeline."] = true
L["Splash Effect"] = true
L["If checked, show a splash effect when icons expire."] = true
L["Set horizontal offset for splash effect."] = true
L["Set vertical offset for splash effect."] = true
L["Overlap Switch"] = true
L["If checked, when icons overlap, switch which is shown on top (otherwise always show icon with shortest time remaining on top)."] = true
L["Switch Time"] = true
L["Set time between switching overlapping icons."] = true
L["Overlap Percent"] = true
L["Set percent overlap that triggers extra offset and switching icons."] = true
L["Set vertical offset from center of timeline for icons."] = true
L["Overlap Offset"] = true
L["Set additional vertical offset for overlapping icons."] = true
L["Hide Empty"] = true
L["If checked, hide the timeline when there are no active icons."] = true
L["Horizontal Stripe Options"] = true
L["If checked, display a horizontal stripe under the bars."] = true
L["Full Width"] = true
L["If checked, horizontal stripe will be the full width of the display and will automatically adjust to fit."] = true
L["Set width of the stripe."] = true
L["Set height of the stripe."] = true
L["Select texture for the stripe."] = true
L["Set opacity for the stripe."] = true
L["Color for the stripe."] = true
L["Stripe Border"] = true
L["Select border for the stripe (select None to disable border)."] = true
L["Alt Color"] = true
L["Alternative color for the stripe that is used if color condition is true."] = true
L["If checked, alternative color is used when the selected condition is true."] = true
L["Condition tested for alternative color."] = true
L["Stripe Inset"] = true
L["Set horizontal offset from anchor for the stripe."] = true
L["Stripe Offset"] = true
L["Set vertical offset from anchor for the stripe."] = true
L["Bar Inset"] = true
L["Set horizontal offset from ends of stripe for bars."] = true
L["Bar Offset"] = true
L["Set vertical offset from center of stripe for bars."] = true
L["If checked, format options are set to default values."] = true
L["Reset format for this bar group back to the current defaults."] = true
L["Format"] = true
L["Icon"] = EMBLEM_SYMBOL
L["Show icon string"] = "Show icon (note: stack count overlay is hidden when icon is not shown, enable Count to add stack count to bar label)."
L["Clock"] = TIMEMANAGER_TITLE
L["Show clock animation on icons for timer bars."] = true
L["Bar"] = true
L["Show colored bar and background."] = true
L["Spark"] = true
L["Show spark that moves across bars to indicate remaining time."] = true
L["Label"] = true
L["Show label text on bars."] = true
L["Count"] = true
L["Show stack count in parentheses after label (it is also displayed as overlay on icon)."] = true
L["Time"] = true
L["Show time left on bars that have a duration."] = true
L["Tooltips"] = true
L["Show tooltips when the cursor is over a bar's icon."] = true
L["Text Settings"] = true
L["Label Text Inset"] = true
L["Set horizontal inset for label from edge of bar."] = true
L["Label Text Offset"] = true
L["Set vertical offset for label text from center of bar."] = true
L["Wrap"] = true
L["If checked, wrap label text when it doesn't fit in the bar's width."] = true
L["Top"] = true
L["If checked, set \"Top\" vertical alignment for label text."] = true
L["Middle"] = true
L["If checked, set \"Middle\" vertical alignment for label text."] = true
L["Bottom"] = true
L["If checked, set \"Bottom\" vertical alignment for label text."] = true
L["If checked, set \"Center\" horizontal alignment for label text, otherwise align based on bar layout (only applies to bar configurations)."] = true
L["Time Text Inset"] = true
L["Set horizontal inset for time text from edge of bar."] = true
L["Time Text Offset"] = true
L["Set vertical offset for time text from center of bar."] = true
L["If checked, use normal alignment for time text, based on bar layout."] = true
L["Left"] = true
L["If checked, set \"Left\" alignment for time text."] = true
L["Center"] = true
L["If checked, set \"Center\" alignment for time text."] = true
L["Right"] = true
L["If checked, set \"Right\" alignment for time text."] = true
L["Icon Text Inset"] = true
L["Set horizontal inset for icon text from middle of icon."] = true
L["Icon Text Offset"] = true
L["Set vertical offset for icon text from center of icon."] = true
L["If checked, hide count overlay text on icon."] = true
L["If checked, set \"Left\" alignment for icon text."] = true
L["If checked, set \"Center\" alignment for icon text."] = true
L["If checked, set \"Right\" alignment for icon text."] = true
L["If checked, time text is shown on the icon instead of the bar (only applies to bar configurations)."] = true
L["Adjust Label Width"] = true
L["If checked, adjust the label width (only applies to bar configurations and required for word wrap)."] = true
L["Auto Adjust"] = true
L["If checked, automatically adjust label width to not overlap horizontally with time value."] = true
L["Label Width"] = true
L["Set label width as percentage of bar width."] = true
L["Icon Configuration Options"] = true
L["Set how many bars/icons to display before wrapping to next row or column. If this is set to 0 then wrapping is disabled."] = true
L["Wrap Direction"] = true
L["If checked, wrap up when arranged in rows or to the right when arranged in columns, otherwise wrap down or to the left."] = true
L["If checked and the bar group is locked, snap to center at the anchor position."] = true
L["Display Position"] = true
L["Horizontal"] = true
L["Set horizontal position as percentage of overall width (cannot move beyond edge of display)."] = true
L["Vertical"] = true
L["Set vertical position as percentage of overall height (cannot move beyond edge of display)."] = true
L["Bar/Icon Limit"] = true
L["Set the maximum number of bars/icons to display (the ones that sort closest to the anchor have priority). If this is set to 0 then the number is not limited."] = true
L["Segment"] = true
L["If checked then bars are shown in segments (additional options are displayed when enabled)."] = true
L["Fill"] = true
L["If checked then timer bars fill up, otherwise they empty."] = true
L["horizontal bars string"] = "If checked, display bars side-by-side in a row on a horizontal backdrop. This layout supports " ..
	"custom bars for brokers with variable width and special alignment options. It does not support wrapping the bars across multiple rows."
L["Test Mode"] = true
L["Unlimited Duration"] = true
L["Set the number of unlimited duration bars/icons to generate in test mode."] = true
L["Timers"] = true
L["Set the number of timer bars/icons to generate in test mode."] = true
L["Refresh Timers"] = true
L["If checked, timers are refreshed when they expire, otherwise they disappear."] = true
L["Toggle Test Mode"] = true
L["Toggle display of test bars/icons."] = true
L["Toggle Overlay"] = true
L["Toggle overlay grid for aligning UI elements (see Defaults tab for options)."] = true
L["Overlay Options"] = true
L["Lines"] = true
L["Adjust number of lines displayed for the overlay."] = true
L["Center Line"] = true
L["Set color for the overlay's center horizontal and vertical lines."] = true
L["Other Lines"] = true
L["Set color for the other overlay lines."] = true
L["Set opacity for the overlay."] = true
L["Toggle overlay grid for aligning UI elements."] = true
L["Attachment"] = true
L["Select a bar group to attach to (for independent position, attach to self)."] = true
L["Offset X"] = true
L["Set horizontal offset from the selected bar group."] = true
L["Offset Y"] = true
L["Set vertical offset from the selected bar group."] = true
L["Last Bar"] = true
L["If checked, position is relative to last bar/icon in the selected bar group."] = true
L["Empty"] = true
L["If checked, offsets are not applied if the selected bar group is empty."] = true
L["By Row"] = true
L["When wrap is enabled in the selected bar group, position is relative to last bar/icon in row closest to the anchor."] = true
L["By Column"] = true
L["When wrap is enabled in the selected bar group, position is relative to last bar/icon in column closest to the anchor."] = true
L["Parent Frame"] = true
L["Enter name of parent frame for this bar group (leave blank to use default)."] = true
L["Anchor Frame"] = true
L["Enter name of anchor frame to attach to (leave blank to enable bar group attachment)."] = true
L["Anchor Point"] = true
L["Select point on anchor frame to attach to."] = true
L["Reset attachment options."] = true
L["Frame Stack"] = DEBUG_FRAMESTACK
L["Toggle showing Blizzard's frame stack tooltips."] = true

-- Bar Groups > Appearance tab
L["Appearance"] = true
L["Use Defaults"] = true
L["If checked, fonts and textures use the default values."] = true
L["Restore Defaults"] = true
L["Reset fonts and textures for this bar group back to the current defaults."] = true
L["Copy From"] = true
L["Select bar group to copy font and texture settings from."] = true
L["If checked, colors use the default values."] = true
L["Reset standard colors for this bar group back to the current defaults."] = true
L["Select bar group to copy standard colors from."] = true
L["Bar Color Scheme"] = true
L["Foreground:"] = true
L["Show bars in default colors for their type, including special debuff colors when applicable."] = true
L["Color the bars with a custom color."] = true
L["Spell Colors"] = true
L["Show bars using spell colors when possible, otherwise use default bar colors."] = true
L["Background:"] = true
L["Same as Foreground"] = true
L["Color the background the same as the foreground."] = true
L["Color the background with a custom color."] = true
L["Icon Border:"] = true
L["Color the icon border the same as the bar foreground."] = true
L["Color the icon border with a custom color."] = true
L["Special"] = true
L["Color the icon border special string"] = "Use special colors for icon border for buffs (stealable, magic, enrage) and debuffs (magic, disease, poison, curse). Use bar colors for generic buffs and debuffs."
L["Color icon border same as bar foreground for spells cast by players, color same as bar background for non-player spells."] = true
L["None"] = true
L["Do not color the icon border."] = true
L["Icon Color:"] = true
L["Desaturate Non-Player"] = true
L["Desaturate if action not cast by player."] = true
L["Only Friendly Target"] = true
L["Desaturate only if the current target is a friend."] = true
L["Class"] = true
L["Show bars using the player's class color."] = true

-- Bar Groups > Timer Options tab
L["Timer Options"] = true
L["Show With Uniform Duration"] = true
L["Show timer bars scaled with a uniform duration (text still shows actual time left)."] = true
L["Only If Longer"] = true
L["Only scale bars if actual duration is greater than the specified uniform duration."] = true
L["Enter minutes in the uniform duration."] = true
L["Enter seconds in the uniform duration."] = true
L["Show If Unlimited Duration"] = true
L["Show bars for actions with unlimited duration (e.g., buffs that don't expire)."] = true
L["Only Show Unlimited"] = true
L["Show bars for actions only if they have unlimited duration."] = true
L["Show As Full Bars"] = true
L["If checked, bars with unlimited duration show as full bars, otherwise they show as empty bars."] = true
L["Ready Reverse"] = true
L["If checked, ready bars show with reverse of Full Bars setting."] = true
L["Unlimited As Zero"] = true
L["If checked, bars with unlimited duration sort as zero duration, otherwise as very long duration."] = true
L["Check Overall Duration"] = true
L["Only include timer bars with a specified minimum (or maximum) duration."] = true
L["Enter minutes for overall duration check."] = true
L["Enter seconds for overall duration check."] = true
L["Check Time Left"] = true
L["Only show timer bars with a specified minimum (or maximum) time left."] = true
L["Enter minutes for time left check."] = true
L["Enter seconds for time left check."] = true
L["Time Format"] = true
L["Time format string"] = "Select time format for bars and icons. There are separate settings for five ranges: " ..
	"more then an hour, 2 minutes to an hour, 1 minute to 2 minutes, 10 seconds to 1 minute, less than 10 seconds. " ..
	"These are illustrated by samples in the drop-down menu for each format option."
L["If checked, time format options are set to default values."] = true
L["Reset time format for this bar group back to the current defaults."] = true
L["Spaces"] = true
L["Include spaces between values in time format."] = true
L["Uppercase"] = true
L["If checked, use uppercase H, M and S in time format, otherwise use lowercase."] = true

-- Conditions tab
L["Conditions"]= true
L["Condition"] = true
L["New Condition"] = true
L["Create a new condition."] = true
L["Enter Condition Name"] = true
L["Enter name of new condition."] = true
L["Cancel creating a new condition."] = true
L["Delete Condition"] = true
L["Delete the selected condition."] = true
L["Delete condition string"] = function(name) string.format('DELETE CONDITION\nAre you sure you want to delete the "%s" condition?', name) end

-- Conditions > General tab
L["Enable Condition"] = true
L["If checked, the condition is enabled and its value is determined by evaluating the associated tests, otherwise the condition is disabled and its value is always false."] = true
L["Notification"] = true
L["If checked, this condition is suitable for a notification and will show up as an option for new notify bars."] = true
L["Detailed Tooltip"] = true
L["If checked, tooltip for notifications based on this condition will include a detailed description."] = true
L["Share Condition"] = true
L["If checked, this condition's settings can be copied between characters."] = true
L["Copy Condition Settings From"] = true
L["Select a shared condition to copy settings from, including tests, associated spells, and dependencies."] = true
L["Reset and delete all current shared condition settings."] = true
L["Rename Condition"] = true
L["Enter new name for the condition."] = true
L["Associated Spell"] = true
L["Enter spell name (or numeric identifier) whose color and icon can be used by notification bars based on this condition."] = true

-- Conditions > Tests tab
L["Tests"] = true
L["Summary"] = ACHIEVEMENT_SUMMARY_CATEGORY
L["Refresh Value"] = true
L["Refresh current value in condition's summary."] = true

-- Conditions > Tests > Player Status
L["Enable Test"] = true
L["Enable"] = ENABLE
L["If checked, enable this test."] = true
L["Combat"] = COMBAT
L["If checked, test combat status."] = true
L["If checked, must be in combat."] = true
L["If checked, must be out of combat."] = true
L["Resting"] = true
L["If checked, test if the player is resting."] = true
L["If checked, player must be resting (e.g., in an inn)."] = true
L["If checked, player must not be resting."] = true
L["Mounted"] = true
L["If checked, test if the player is mounted."] = true
L["If checked, player must be mounted."] = true
L["If checked, player must not be mounted."] = true
L["Stealthed"] = true
L["If checked, test if the player is stealthed."] = true
L["If checked, player must be stealthed."] = true
L["If checked, player must not be stealthed."] = true
L["If checked, bar group is shown when the player is stealthed."] = true
L["PvP"] = true
L["If checked, test if the player has PvP enabled."] = true
L["If checked, player must have PvP enabled."] = true
L["If checked, player must not have PvP enabled."] = true
L["If checked, test if player is in a party."] = true
L["If checked, player must be in a party."] = true
L["If checked, player must not be in a party."] = true
L["If checked, test if player is in raid group."] = true
L["If checked, player must be in a raid group."] = true
L["If checked, player must not be in a raid group."] = true
L["If checked, test if player is in either a party or raid with other players."] = true
L["If checked, player must be in either a party or raid with other players."] = true
L["If checked, player must not be in either a party or raid with other players."] = true
L["If checked, test if player is in a 5-man or raid instance."] = true
L["If checked, player must be in a 5-man or raid instance."] = true
L["If checked, player must not be in a 5-man or raid instance."] = true
L["If checked, test if player is in an arena."] = true
L["If checked, player must be in an arena."] = true
L["If checked, player must not be in an arena."] = true
L["If checked, test if player is in a battleground."] = true
L["If checked, player must be in a battleground."] = true
L["If checked, player must not be in a battleground."] = true
L["If checked, test if the player has a pet."] = true
L["If checked, player must have a pet."] = true
L["If checked, player must not have a pet"] = true
L["Player"] = PLAYER
L["Pet"] = PET
L["Level"] = true
L["If checked, test the player's level."] = true
L["If checked, player must be at least at this level, otherwise must be lower."] = true
L["If checked, test the player's health."] = true
L["If checked, player's health must be at least this percentage, otherwise must be less."] = true
L["If checked, test the player's power (i.e., mana, rage, energy, focus, runic power)."] = true
L["If checked, player's power must be at least this percentage, otherwise must be less."] = true
L["If checked, test the player's holy power."] = true
L["If checked, player's holy power must be at least this many charges, otherwise must be less."] = true
L["If checked, test the player's number of soul shards."] = true
L["If checked, player must have at least this many soul shards, otherwise must be less."] = true
L["If checked, test the player's arcane charges."] = true
L["If checked, player must have at least this many arcane charges, otherwise must be less."] = true
L["If checked, test the player's insanity level."] = true
L["If checked, player must have at least this amount of insanity, otherwise must be less."] = true
L["If checked, test the player's maelstrom level."] = true
L["If checked, player must have at least this amount of maelstrom, otherwise must be less."] = true
L["If checked, test the player's chi."] = true
L["If checked, player must have at least this much chi, otherwise must be less."] = true
L["If checked, test the player's lunar power. You can set power level and the comparison to use (either less or greater than the power level)."] = true
L["If checked, player's lunar power must be at least this level, otherwise must be less."] = true
L["Available"] = true
L["Any"] = true
L["If checked, test how many available runes the player has."] = true
L["If checked, player must have at least this many available runes, otherwise must be fewer."] = true
L["If checked, test how many combo points the player has on the target."] = true
L["If checked, player must have at least this many combo points, otherwise must be fewer."] = true
L["If checked, test the player's totem status."] = true
L["Totem Name"] = true
L["Enter name of specific totem to check is active."] = true
L["Health"] = HEALTH
L["Power"] = ATTACK_POWER
L["Minimum"] = MINIMUM
L["Holy Power"] = HOLY_POWER
L["Soul Shards"] = SOUL_SHARDS_POWER
L["Insanity"] = INSANITY_POWER
L["Maelstrom"] = MAELSTROM_POWER
L["Arcane Charges"] = true
L["Lunar Power"] = true
L["Chi"] = CHI
L["Combo Points"] = COMBO_POINTS
L["If checked, test if the player has a mainhand weapon equipped with at least the specified item level."] = true
L["If checked, test if the player has an offhand weapon equipped with at least the specified item level."] = true
L["If checked, test if the player is in a stance."] = true
L['Enter the stance to check for (enter "none" to check for no stance).'] = true
L["If checked, test if player's talents include a specific talent."] = true
L["If checked, test player's specialization."] = true
L['Enter comma-separated specialization names or numbers (enter "none" to check for no specialization).'] = true
L["If checked, test if a spell is in the player's spellbook."] = true
L['Enter a spell name (or numeric identifier) to test is known in the spellbook.'] = true
L["Weapons"] = true
L["Mainhand"] = true
L["Offhand"] = true
L["Stance"] = true
L["Talent"] = TALENT
L["Specialization"] = SPECIALIZATION
L["Spellbook"] = SPELLBOOK

-- Conditions > Tests > Pet Status
L["Pet Status"] = true
L["If checked, test if pet currently exists."] = true
L["If checked, pet must exist."] = true
L["If checked, pet must not exist."] = true
L["If checked, test pet's target."] = true
L["No Target"] = true
L["If checked, must not have a target."] = true
L["Player's Target"] = true
L["If checked, must be same as player's target."] = true
L["Any Target"] = true
L["If checked, must have a target."] = true
L["If checked, test the pet's health."] = true
L["If checked, pet's health must be at least this percentage, otherwise must be less."] = true
L["If checked, test the pet's power (i.e., mana, rage, energy, focus)."] = true
L["If checked, pet's power must be at least this percentage, otherwise must be less."] = true
L["Family"] = true
L["If checked, test pet's creature family."] = true
L['Enter the creature family to check for (enter "none" to check if not applicable).'] = true
L["Talent Tree"] = true
L["If checked, test pet's talent tree."] = true
L['Enter the talent tree to check for (enter "none" to check for no talents).'] = true

-- Conditions > Tests > Target Status
L["If checked, test if target currently exists."] = true
L["If checked, target must exist."] = true
L["If checked, target must not exist."] = true
L["If checked, test if the target is a player."] = true
L["If checked, target must be a player."] = true
L["If checked, target must not be a player."] = true
L["If checked, test if the target is an enemy."] = true
L["If checked, target must be an enemy."] = true
L["If checked, target must not be an enemy."] = true
L["If checked, test if the target is friendly."] = true
L["If checked, target must be friendly."] = true
L["If checked, target must not be friendly."] = true
L["Dead"] = DEAD
L["If checked, test if the target is dead."] = true
L["If checked, target must be dead."] = true
L["If checked, target must not be dead."] = true
L["Classification"] = true
L["If checked, test the target's classification (you can select multiple classifications)."] = true
L["If checked, test for normal classification."] = true
L["If checked, test for boss classification."] = true
L["If checked, test for elite classification."] = true
L["If checked, test for rare classification."] = true
L["If checked, test for rare elite classification."] = true
L["Range"] = true
L["If checked, test if the target is in range."] = true
L["If checked, target must be in range."] = true
L["If checked, target must not be in range."] = true
L["Spellsteal"] = true
L["Not Spellsteal"] = true
L["If checked, test for a buff that can be transferred to the player with Spellsteal."] = true
L["If checked, there must be a spellstealable buff."] = true
L["If checked, there must not be a spellstealable buff."] = true
L["If checked, test the target's health."] = true
L["If checked, target's health must be at least this percentage, otherwise must be less."] = true
L["If checked, test the target's power (i.e., mana, rage, energy, focus, runic power)."] = true
L["If checked, target's power must be at least this percentage, otherwise must be less."] = true
L["Maximum Health"] = true
L["If checked, test the target's maximum health."] = true
L["Enter minimum value for target's maximum health required for test to be true."] = true

-- Conditions > Tests > Target's Target Status
L["If checked, test if target's target currently exists."] = true
L["If checked, target's target must exist."] = true
L["If checked, target's target must not exist."] = true
L["If checked, test if the target's target is a player."] = true
L["If checked, target's target must be a player."] = true
L["If checked, target's target must not be a player."] = true
L["If checked, test if the target's target is an enemy."] = true
L["If checked, target's target must be an enemy."] = true
L["If checked, target's target must not be an enemy."] = true
L["If checked, test if the target's target is friendly."] = true
L["If checked, target's target must be friendly."] = true
L["If checked, target's target must not be friendly."] = true
L["If checked, test if the target's target is dead."] = true
L["If checked, target's target must be dead."] = true
L["If checked, target's target must not be dead."] = true
L["If checked, test the target's target classification (you can select multiple classifications)."] = true
L["If checked, test if the target's target is in range."] = true
L["If checked, target's target must be in range."] = true
L["If checked, target's target must not be in range."] = true
L["If checked, test the target's target health."] = true
L["If checked, target's target health must be at least this percentage, otherwise must be less."] = true
L["If checked, test the target's target power (i.e., mana, rage, energy, focus, runic power)."] = true
L["If checked, target's target power must be at least this percentage, otherwise must be less."] = true
L["If checked, test the target's target maximum health."] = true
L["Enter minimum value for target's target maximum health required for test to be true."] = true

-- Conditions > Tests > Focus Status
L["If checked, test if focus currently exists."] = true
L["If checked, focus must exist."] = true
L["If checked, focus must not exist."] = true
L["If checked, test if the focus is a player."] = true
L["If checked, focus must be a player."] = true
L["If checked, focus must not be a player."] = true
L["If checked, test if the focus is an enemy."] = true
L["If checked, focus must be an enemy."] = true
L["If checked, focus must not be an enemy."] = true
L["If checked, test if the focus is friendly."] = true
L["If checked, focus must be friendly."] = true
L["If checked, focus must not be friendly."] = true
L["If checked, test if the focus is dead."] = true
L["If checked, focus must be dead."] = true
L["If checked, focus must not be dead."] = true
L["If checked, test the focus's classification (you can select multiple classifications)."] = true
L["If checked, test if the focus is in range."] = true
L["If checked, focus must be in range."] = true
L["If checked, focus must not be in range."] = true
L["If checked, test the focus's health."] = true
L["If checked, focus's health must be at least this percentage, otherwise must be less."] = true
L["If checked, test the focus's power (i.e., mana, rage, energy, focus, runic power)."] = true
L["If checked, focus's power must be at least this percentage, otherwise must be less."] = true

-- Conditions > Tests > Focus's Target Status
L["If checked, test if focus target currently exists."] = true
L["If checked, focus target must exist."] = true
L["If checked, focus target must not exist."] = true
L["If checked, test if the focus target is a player."] = true
L["If checked, focus target must be a player."] = true
L["If checked, focus target must not be a player."] = true
L["If checked, test if the focus target is an enemy."] = true
L["If checked, focus target must be an enemy."] = true
L["If checked, focus target must not be an enemy."] = true
L["If checked, test if the focus target is friendly."] = true
L["If checked, focus target must be friendly."] = true
L["If checked, focus target must not be friendly."] = true
L["If checked, test if the focus target is dead."] = true
L["If checked, focus target must be dead."] = true
L["If checked, focus target must not be dead."] = true
L["If checked, test the focus target's classification (you can select multiple classifications)."] = true
L["If checked, test if the focus target is in range."] = true
L["If checked, focus target must be in range."] = true
L["If checked, focus target must not be in range."] = true
L["If checked, test the focus target's health."] = true
L["If checked, focus target's health must be at least this percentage, otherwise must be less."] = true
L["If checked, test the focus target's power (i.e., mana, rage, energy, focus, runic power)."] = true
L["If checked, focus target's power must be at least this percentage, otherwise must be less."] = true

-- Conditions > Tests > All Buffs
L["Buff List Entry"] = true
L["Test Buffs"] = true
L["Who Has Buff"] = true
L["Who Cast Buff"] = true
L["Enter comma-separated list of buffs."] = true
L["If checked, test if all the buffs are active."] = true
L["If checked, test if any of the buffs are not active."] = true
L["If checked, test if player buffs."] = true
L["If checked, test if target buffs."] = true
L["If checked, test if focus buffs."] = true
L["If checked, test if the buffs were cast by the player."] = true
L["If checked, test if the buffs were cast by anyone other than the player."] = true
L["If checked, buffs may be cast by anyone, including the player."] = true
L["On Player"] = true
L["On Target"] = true
L["On Focus"] = true
L["Cast By Target"] = true
L["Cast By Focus"] = true

-- Conditions > Tests > Any Buffs
L["If checked, test if any of the buffs are active."] = true
L["If checked, test if none of the buffs are active."] = true

-- Conditions > Tests > Buff Time Left
L["Buff Entry"] = true
L["Enter the buff to be tested."] = true
L["Minutes"] = true
L["Seconds"] = true
L["If checked, test if buff is on player."] = true
L["If checked, test if buff is on pet."] = true
L["If checked, test if buff is on target."] = true
L["If checked, test if buff is on focus."] = true
L["If checked, test if the buff was cast by the player."] = true
L["If checked, test if the buff was cast by anyone other than the player."] = true
L["If checked, buff may be cast by anyone, including the player."] = true

-- Conditions > Tests > Buff Count
L["Enter buff to test for stack count (if buff doesn't stack then its count is 0)."] = true
L["Stack Count"] = true
L["Enter value to compare with the buff stack count."] = true
L["Comparison"] = true

-- Conditions > Tests > Buff Type
L["Player Has Buff"] = true
L["If checked, player must have a mainhand buff."] = true
L["If checked, player must have an offhand buff."] = true
L["If checked, true if player has a buff of the specified type."] = true
L["If checked, true if player does not have a buff of the specified type."] = true
L["Result"] = true

-- Conditions > Tests > All Debuffs
L["Debuff List Entry"] = true
L["Test Debuffs"] = true
L["Who Has Debuff"] = true
L["Who Cast Debuff"] = true
L["Enter comma-separated list of debuffs."] = true
L["If checked, test if all the debuffs are active."] = true
L["If checked, test if any of the debuffs are not active."] = true
L["If checked, test if debuff is on player."] = true
L["If checked, test if debuff is on pet."] = true
L["If checked, test if debuff is on target."] = true
L["If checked, test if debuff is on focus."] = true
L["If checked, test if the debuffs were cast by the player."] = true
L["If checked, test if the debuffs were cast by anyone other than the player."] = true
L["If checked, debuffs may be cast by anyone, including the player."] = true

-- Conditions > Tests > Any Debuffs
L["If checked, test if any of the debuffs are active."] = true
L["If checked, test if none of the debuffs are active."] = true

-- Conditions > Tests > Debuff Time Left
L["Enter the debuff to be tested."] = true
L["Debuff Entry"] = true
L["If checked, test if the debuff was cast by the player."] = true
L["If checked, test if the debuff was cast by anyone other than the player."] = true
L["If checked, debuff may be cast by anyone, including the player."] = true

-- Conditions > Tests > Debuff Count
L["Enter debuff to test for stack count (if debuff doesn't stack then its count is 0)."] = true
L["Enter value to compare with the debuff stack count."] = true

-- Conditions > Tests > Debuff Type
L["Player Has Debuff"] = true
L["If checked, player must have a poison debuff."] = true
L["If checked, player must have a disease debuff."] = true
L["If checked, player must have a curse debuff."] = true
L["If checked, player must have a magic debuff."] = true
L["If checked, true if player has a debuff of the specified type."] = true
L["If checked, true if player does not have a debuff of the specified type."] = true

-- Conditions > Tests > All Cooldowns
L["Spell List Entry"] = true
L["If checked, test if spells are usable (i.e., enough mana, reagents, etc.)."] = true
L["Enter comma-separated list of spells."] = true
L["Enter seconds for cooldown time left check."] = true

-- Conditions > Tests > Spell Ready
L["Spell Entry"] = true
L["Spell"] = STAT_CATEGORY_SPELL
L["Enter spell name (or numeric identifier, optionally preceded by # for a specific spell id) to test if ready to be cast."] = true
L["If checked, test if spell is on global cooldown, otherwise ignore global cooldown."] = true
L["Is Usable"] = true
L["If checked, test if spell is usable (i.e., enough mana, reagents, etc.)."] = true
L["If checked, also test if the target is in range of the spell."] = true
L["If checked, target must be in range."] = true
L["If checked, target must be out of range."] = true
L["If checked, test the number of charges on the spell."] = true

-- Conditions > Tests > Spell Casting
L["Enter spell to test if being cast or channeled."] = true
L["Who Is Casting"] = true
L["If checked, test player casting."] = true
L["If checked, test target casting."] = true
L["If checked, test focus casting."] = true

-- Conditions > Tests > Item Ready
L["Item Entry"] = true
L["Item"] = ENCOUNTER_JOURNAL_ITEM
L["Enter name or itemID of item to test. Item must be in the player's bags. Use generic cooldown names for Potions and Elixirs."] = true
L["Ready"] = true
L["If checked, test if the item is ready to use."] = true
L["If checked, item must be ready."] = true
L["If checked, item must not be ready."] = true
L["If checked, test item count."] = true
L["Enter value to compare with item count."] = true
L["Charges"] = true
L["If checked, test the number of charges on the item(s)."] = true
L["Enter value to compare with the number of charges."] = true

-- Conditions > Tests > Result
L["Dependencies"] = true
L["Dependencies string"] = "Dependencies are other conditions that must evaluate to specific results for this condition's result to be true. " ..
	"Dependencies are grouped either with a logical \"And\" (all \"And\" dependencies must evaluate to their specified results) " ..
	"or logical \"Or\" (at least one \"Or\" dependency must evaluate to its specified result). " ..
	"Note that all other tests are evaluated for all conditions before checking dependencies.\n"
L["True"] = true
L["Condition is true only if the selected condition evaluates to true."] = true
L["False"] = true
L["Condition is true only if the selected condition evaluates to false."] = true
L["And/Or"] = true
L["And"] = true
L["Or"] = true
L["Toggle between logical \"And\" and \"Or\" for this dependecy."] = true
L["Delete"] = DELETE
L["Delete this condition from the dependencies list."] = true
L["Test Evaluation"] = true
L["If checked, evaluate all enabled tests with logical \"And\" (i.e., all tests must be true), othewise use logical \"Or\" (i.e., only one test must be true)."] = true
L["Toggle Result"] = true
L["If checked, the result for this condition, after evaluating all tests and checking dependencies, is toggled."] = true
L["Set Result"] = true
L["If checked, the result for this condition is set to true or false (this feature is provided to help debug conditions)."] = true
L["If checked, result is set to true."] = true
L["If checked, result is set to false."] = true
L["Modifiers"] = true
L["Shift"] = true
L["Control"] = true
L["Alt"] = true
L["Toggle result if selected modifier keys are all down."] = true
L["Modifier Key String"] = function(mks) return string.format(" Toggle result if \"%s\"", mks) end

-- In-Combat Buffs tab
L["In-Combat Bar"] = true
L["Enable In-Combat Bar"] = true
L["In-combat string"] = "Raven includes an optional \"in-combat bar\" that you can use to cancel buffs while in combat. You configure the bar's layout and select the buffs you want to be able to cancel using the options listed here. When any of the selected buffs become active in combat, the buff's icon pulses into visibility on the bar and you can right-click the icon to cancel the buff. |cffedd400PLEASE NOTE:|r You may need to reload your user interface in order for changes to take effect.\n"
L["Enable in-combat buffs string"] = "Enable bar for displaying buff icons that can be right-clicked to cancel in combat."
L["Lock Bar Layout"] = true
L["Lock in-combat string"] = "Lock and hide the bar layout once it is configured."
L["Link Bar Layout"] = true
L["Link in-combat settings string"] = "Layout settings (but not buff lists) are shared for all profiles that have Link Bar Layout checked."
L["Out Of Combat"] = true
L["If checked, also display buffs on the bar when out of combat."] = true
L["Enter in-combat buff string"] = "Enter player buff name to add to the in-combat list."
L["Buff List"] = true
L["Delete the selected buff from the in-combat list."] = true
L["Reset the in-combat buff list."] = true
L["Set size for the buff icons."] = true
L["Horizontal Bar"] = true
L["Configure as a horizontal bar of buff icons."] = true
L["Vertical Bar"] = true
L["Configure as a vertical bar of buff icons."] = true
L["Spacing"] = true
L["Set spacing between the buff icons."] = true
L["Set scale factor for the bar."] = true
L["Set normal opacity for the bar."] = true
L["Mainhand Weapon"] = true
L["Offhand Weapon"] = true
L["Enter name of anchor frame to attach to (leave blank to enable manual positioning)."] = true
L["Enable icon pulse when buff icon is started."] = true
L["Enable icon pulse when buff icon is expiring."] = true
L["Enable flashing of expiring buff icons."] = true
L["Set number of seconds before expiration that buff icon should start flashing."] = true
L["Fade Unless Mouseover"] = true
L["Enable fading of buff icons unless mouseover is detected."] = true
L["Fade Opacity"] = true
L["Set fade opacity for buff icon when mouseover is not detected."] = true
L["By default, buff icons are displayed with a custom border. If this option is checked then custom borders are hidden."] = true

-- Inserted Bar Information tab
L["Bar Information"] = true
L["Custom Sort Order"] = true
L["Move Up"] = true
L["Move the bar up, overriding sort order."] = true
L["Move Down"] = true
L["Move the bar down, overriding sort order."] = true
L["If checked, enable showing the bar."] = true
L["Hide Label"] = true
L["If checked, hide the label for this bar."] = true
L["Enter label text for the bar."] = true
L["Label Link"] = true
L["If checked, label is linked to the associated spell and changing it here will change it for all bars linked to the same spell."] = true
L["Add Tooltip Number"] = true
L["If checked, a number found in the tooltip is added to the label. If label contains the string TT# then the number replaces the label."] = true
L["Number Position"] = true
L["Set which number in tooltip to add to label. Supports decimals although can affect position."] = true
L["Show When Ready"] = true
L["If checked, show ready bar when action is not on cooldown. Ready bars are a special kind of unlimited duration bar so make sure Timer Options are set appropriately."] = true
L["Show Not Active"] = true
L["If checked, show ready bar when action is not active. Ready bars are a special kind of unlimited duration bar so make sure Timer Options are set appropriately."] = true
L["Usable"] = true
L["If checked, show ready bar only if spell is usable (i.e., enough mana, reagents, etc.)."] = true
L["If checked, apply ready opacity when spell has at least one charge."] = true
L["Set number of seconds to show the ready bar (0 for unlimited time)."] = true
L["Use Spell Color"] = true
L["If checked, use color from associated spell."] = true
L["Use Spell Icon"] = true
L["If checked, use icon from associated spell."] = true
L["Color Link"] = true
L["If checked, the color is linked to the associated spell and changing it here will change it for all bars linked to the same spell."] = true
L["Conditional Effects"] = true
L["Hide"] = true
L["If checked, bar is conditionally hidden."] = true
L["If checked, bar is hidden if the condition is true."] = true
L["If checked, bar is hidden if the condition is false."] = true
L["Hide Condition"] = true
L["Flash"] = true
L["If checked, bar will conditionally flash."] = true
L["If checked, bar will flash if the condition is true."] = true
L["If checked, bar will flash if the condition is false."] = true
L["Flash Condition"] = true
L["If checked, bar will conditionally show glow effect"] = true
L["If checked, bar will glow if the condition is true."] = true
L["If checked, bar will glow if the condition is false."] = true
L["Glow Condition"] = true
L["Fade"] = true
L["If checked, bar will conditionally change from normal opacity to fade opacity."] = true
L["If checked, bar will fade if the condition is true."] = true
L["If checked, bar will fade if the condition is false."] = true
L["Fade Condition"] = true
L["If checked, spell color is overridden based on the value of the condition (in order to show spell color, the Bar Color Scheme on Appearance tab for Foreground must be set to Spell)."] = true
L["Set bar color for when condition is true (set invisible opacity to disable color change)."] = true
L["Set bar color for when condition is false (set invisible opacity to disable color change)."] = true
L["Color Condition"] = true
L["Normal Opacity"] = true
L["Set normal opacity for this bar."] = true
L["Set fade opacity for this bar."] = true
L["Fade Effects"] = true
L["Set opacity for bar group when in combat."] = true
L["Set opacity for bar group when out of combat."] = true
L["Set opacity for bar group when mouse is over it (overrides in and out of combat opacities)."] = true
L["Set opacity for faded bars."] = true
L["Set opacity for faded bar."] = true
L["Ready Bars"] = true
L["Set opacity for ready bar."] = true
L["Type"] = true
L["If checked, this is a notify bar."] = true
L["If checked, this is a buff bar."] = true
L["If checked, this is a debuff bar."] = true
L["If checked, this is a cooldown bar."] = true
L["Source"] = true
L["Action"] = true
L["If checked, select actions associated with a class."] = true
L["If checked, select actions associated with a pet."] = true
L["If checked, select actions associated with a race."] = true
L["If checked, enter spell name for an associated action."] = true
L["Druid"] = true
L["If checked, select druid actions."] = true
L["Hunter"] = true
L["If checked, select hunter actions."] = true
L["Mage"] = true
L["If checked, select mage actions."] = true
L["Monk"] = true
L["If checked, select monk actions."] = true
L["Paladin"] = true
L["If checked, select paladin actions."] = true
L["Priest"] = true
L["If checked, select priest actions."] = true
L["Rogue"] = true
L["If checked, select rogue actions."] = true
L["Shaman"] = true
L["If checked, select shaman actions."] = true
L["Warlock"] = true
L["If checked, select warlock actions."] = true
L["Warrior"] = true
L["If checked, select warrior actions."] = true
L["Death Knight"] = true
L["If checked, select death knight actions."] = true
L["Demon Hunter"] = true
L["If checked, select demon hunter actions."] = true
L["Conditions To Monitor"] = true
L["Select all the conditions."] = true
L["Deselect all the conditions."] = true
L["Enter Spell Name or Identifier"] = true
L["Actions To Monitor"] = true
L["All On"] = true
L["Select all the actions."] = true
L["All Off"] = true
L["Deselect all the actions."] = true
L["Unconditional"] = true
L["If checked, the notify bar is always shown (note only one unconditional bar may be created per bar group)."] = true
L["If checked, must be on the player."] = true
L["If checked, must be on the player's pet."] = true
L["If checked, must be on the target."] = true
L["If checked, must be on the focus."] = true
L["If checked, must be on the mouseover unit."] = true
L["If checked, must be on the pet's target."] = true
L["If checked, must be on the target's target."] = true
L["If checked, must be on the focus's target."] = true
L["If checked, only track if cast by the player."] = true
L["If checked, only track if cast by the player's pet."] = true
L["If checked, only track if cast by anyone other than the player."] = true
L["If checked, track if cast by anyone, including player and pet."] = true
L["OK"] = true
L["Notification Settings"] = true
L["Use Condition's Spell"] = true
L["If checked, use the condition's associated spell."] = true
L["Value Settings"] = true
L["If checked, this is a value bar."] = true
L["Data For Values"] = true
L["Enter a spell name (or numeric identifier, optionally preceded by # for a specific spell id). This may be used by certain value types."] = true
L["Optional Text"] = true
L["Enter text that may be used by certain value types."] = true
L["If checked, hide the icon (note the bar group must also enable showing icons, this only provides a way to hide individual icons)."] = true
L["If checked, hide the text (note the bar group must also enable showing time text, this only provides a way to hide individual texts)."] = true
L["If checked, hide the label (note bar group must also enable showing labels, this only provides a way to hide individual labels)."] = true
L["If checked, hide the bar (note the bar group must also enable showing bars, this only provides a way to hide individual bars)."] = true
L["If checked, show the value's icon, if any, in place of bar's default icon."] = true
L["If checked, show the value's text, if any, in place of bar's default text."] = true
L["If checked, show the value's label, if any, in place of bar's default label."] = true
L["If checked, apply the value's color, if any, to icon's border."] = true
L["If checked, apply the value's color, if any, to bar's foreground."] = true
L["If checked, apply the value's color, if any, to bar's background."] = true
L["Color Foreground"] = true
L["Color Background"] = true
L["Hide 0"] = true
L["Hide Max"] = true
L["If checked, hide when value is 0 (and max value is non-zero)."] = true
L["If checked, hide when at max value (and max value is non-zero)."] = true
L["If checked, hide value bar when value is 0 (and max value is non-zero)."] = true
L["If checked, hide value bar when at max value (and max value is non-zero)."] = true
L["If checked, show the value using a text format (select below)."] = true
L["Value uses a custom format."] = "|cFF7adbf2Value uses a built-in format.|r"
L["314 (Integer)"] = true
L["If checked, show value as an integer."] = true
L["31.4 (1 Decimal Place)"] = true
L["If checked, show value as a number with one decimal place."] = true
L["3.14 (2 Decimal Places)"] = true
L["If checked, show value as a number with two decimal place."] = true
L["31% (Percentage)"] = true
L["If checked, show value as percentage of maximum value."] = true
L["3:14 (Minutes:Seconds)"] = true
L["If checked, show value as a timer in minutes and seconds."] = true
L["3.1/14 (Value/Max)"] = true
L["If checked, show value and maximum value as numbers separated by '/'."] = true
L["Broker"] = true
L["Broker To Monitor"] = true
L["Brokers"] = true
L["If checked, this is a data broker bar."] = true
L["Broker select string"] = "Select a data broker to monitor with this bar."
L["Broker Settings"] = true
L["If checked, show the data broker's icon."] = true
L["Text"] = true
L["If checked, show the data broker's text."] = true
L["If checked, show a bar for the data broker."] = true
L["If showing a bar, set a horizontal inset from icon."] = true
L["If checked, add data broker's label to its text or, if Icon Text is also enabled, use it as label."] = true
L["Use Value"] = true
L["If checked, use data broker's value (or text if no value provided) as bar's icon text."] = true
L["Numeric"] = true
L["If checked, use the first number found within the text."] = true
L["Recolor"] = true
L["If checked, remove embedded colors from the data broker's text and label."] = true
L["Value: Percentage"] = true
L["If checked, bar shows numeric value as a percentage."] = true
L["Value: Maximum"] = true
L["If checked, bar shows numeric value as fraction of specified maximum."] = true
L["Enter Maximum Value"] = true
L["Value"] = true
L["Frequent Updates"] = true
L["If checked, enable frequent updates to the value."] = true
L["Adjust Segments"] = true
L["If the bar group supports segments then automatically adjust number of segments."] = true
L["Value select string"] = "Select sources for the value and, optionally, the color for the bar."
L["Source Selection"] = true
L["Sources"] = true
L["Colors"] = true
L["Value For"] = true
L["If checked, value is for player."] = true
L["If checked, value is for player's pet."] = true
L["If checked, value is for target."] = true
L["If checked, value is for focus."] = true
L["If checked, value is for mouseover unit."] = true
L["If checked, value is for pet's target."] = true
L["If checked, value is for target's target."] = true
L["If checked, value is for focus's target."] = true
L["Confirm creating new bars for the selected actions/conditions."] = true
L["Cancel creating new bars."] = true
L["Variable Width"] = true
L["If checked (and the bar group's layout supports it), bar width varies depending on the length of the broker's text."] = true
L["Minimum Width"] = true
L["Set minimum text width."] = true
L["Maximum Width"] = true
L["Set maximum text width for this broker (ignored if set to 0)."] = true
L["Align: Left"] = true
L["If checked (and the bar group's layout supports it), align the bar to the left."] = true
L["Align: Right"] = true
L["If checked (and the bar group's layout supports it), align the bar to the right."] = true
L["Align: Center"] = true
L["If checked (and the bar group's layout supports it), align the bar in the center."] = true
L["Graphics Performance"] = true
L["Animation Rate"] = true
L["Animation string"] = "Adjust Raven's animation rate. More refreshes per second may make timer bars move more smoothly at the cost of higher CPU use."
L["Update Rate"] = true
L["Update string"] = "Adjust Raven's update rate. More updates per second may make icons and bars feel more responsive at the cost of higher CPU use."
L["Throttle (In Combat)"] = true
L["Throttle (Out Of Combat)"] = true
L["Throttle string"] = "Adjust Raven's throttle limit (number of updates to skip when no events are detected). A lower limit may increase responsiveness at the cost of higher CPU use."
L["Optional Units For Auto Groups"] = true
L["If checked, party units may be tracked in auto groups (requires /reload)."] = true
L["If checked, boss units may be tracked in auto groups (requires /reload)."] = true
L["If checked, arena units may be tracked in auto groups (requires /reload)."] = true
L["Party 1-4"] = true
L["Boss 1-5"] = true
L["Arena 1-5"] = true

-- Values and colors for value bars
L["Level"] = true
L["Health"] = true
L["Incoming Heals"] = true
L["Health + Incoming"] = true
L["Power"] = true
L["Alt Power"] = true
L["Threat"] = true
L["Absorb"] = true
L["Stagger"] = true
L["Raid Marker"] = true
L["PVP"] = true
L["Map X"] = true
L["Map Y"] = true
L["Position"] = true
L["Facing"] = true
L["Experience"] = true
L["Honor"] = true
L["Reputation"] = true
L["Rested"] = true
L["Monitor"] = true
L["Network"] = true
L["Mirror Timers"] = true
L["Mirror Timer 1"] = true
L["Mirror Timer 2"] = true
L["Mirror Timer 3"] = true
L["Rune 1"] = true
L["Rune 2"] = true
L["Rune 3"] = true
L["Rune 4"] = true
L["Rune 5"] = true
L["Rune 6"] = true
L["Cast Bar"] = true
L["Gold"] = true
L["Mail"] = true
L["Clock"] = true
L["You have mail!"] = true
L["No new mail"] = true
L["Durability"] = true
L["Azerite"] = true
L["Spell Tooltip"] = true
L["Tooltip comment"] = "Show tooltip for the associated spell. Select a tooltip number's position with optional text in order to set the value."
L["Reputation comment"] = "Show reputation for the watched faction."
L["Cast bar comment"] = "Show cast bar for the unit. If optional text includes the string 'latency' and unit is player then latency is displayed with a red tick mark. " ..
	"If optional text includes the string 'interrupt' and cast is not interruptible then a red X is added to the spell name."
